/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListPolicy;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;

public final class ListExp {
    private static final int MODULE = 0;
    private static final int APPEND = 1;
    private static final int APPEND_ITEMS = 2;
    private static final int INSERT = 3;
    private static final int INSERT_ITEMS = 4;
    private static final int SET = 9;
    private static final int CLEAR = 11;
    private static final int INCREMENT = 12;
    private static final int SORT = 13;
    private static final int SIZE = 16;
    private static final int GET_BY_INDEX = 19;
    private static final int GET_BY_RANK = 21;
    private static final int GET_BY_VALUE = 22;
    private static final int GET_BY_VALUE_LIST = 23;
    private static final int GET_BY_INDEX_RANGE = 24;
    private static final int GET_BY_VALUE_INTERVAL = 25;
    private static final int GET_BY_RANK_RANGE = 26;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 27;
    private static final int REMOVE_BY_INDEX = 32;
    private static final int REMOVE_BY_RANK = 34;
    private static final int REMOVE_BY_VALUE = 35;
    private static final int REMOVE_BY_VALUE_LIST = 36;
    private static final int REMOVE_BY_INDEX_RANGE = 37;
    private static final int REMOVE_BY_VALUE_INTERVAL = 38;
    private static final int REMOVE_BY_RANK_RANGE = 39;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 40;

    public static Exp append(ListPolicy policy, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(1, value, policy.attributes, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp appendItems(ListPolicy policy, Exp list, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(2, list, policy.attributes, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp insert(ListPolicy policy, Exp index2, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(3, index2, value, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp insertItems(ListPolicy policy, Exp index2, Exp list, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(4, index2, list, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp increment(ListPolicy policy, Exp index2, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(12, index2, value, policy.attributes, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp set(ListPolicy policy, Exp index2, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(9, index2, value, policy.flags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp clear(Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(11, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp sort(int sortFlags, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(13, sortFlags, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValue(Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(35, 0, value, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueList(Exp values, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(36, 0, values, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRange(Exp valueBegin, Exp valueEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(38, 0, valueBegin, valueEnd, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRelativeRankRange(Exp value, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(40, 0, value, rank, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRelativeRankRange(Exp value, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(40, 0, value, rank, count, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndex(Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(32, 0, index2, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndexRange(Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(37, 0, index2, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndexRange(Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(37, 0, index2, count, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRank(Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(34, 0, rank, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRankRange(Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(39, 0, rank, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRankRange(Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(39, 0, rank, count, ctx);
        return ListExp.addWrite(bin, bytes, ctx);
    }

    public static Exp size(Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(16, ctx);
        return ListExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getByValue(int returnType, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(22, returnType, value, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByValueRange(int returnType, Exp valueBegin, Exp valueEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(25, returnType, valueBegin, valueEnd, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByValueList(int returnType, Exp values, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(23, returnType, values, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(27, returnType, value, rank, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(27, returnType, value, rank, count, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByIndex(int returnType, Exp.Type valueType, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(19, returnType, index2, ctx);
        return ListExp.addRead(bin, bytes, valueType);
    }

    public static Exp getByIndexRange(int returnType, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(24, returnType, index2, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByIndexRange(int returnType, Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(24, returnType, index2, count, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByRank(int returnType, Exp.Type valueType, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(21, returnType, rank, ctx);
        return ListExp.addRead(bin, bytes, valueType);
    }

    public static Exp getByRankRange(int returnType, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(26, returnType, rank, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    public static Exp getByRankRange(int returnType, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(26, returnType, rank, count, ctx);
        return ListExp.addRead(bin, bytes, ListExp.getValueType(returnType));
    }

    private static Exp addWrite(Exp bin, byte[] bytes, CTX[] ctx) {
        int retType = ctx == null || ctx.length == 0 ? Exp.Type.LIST.code : ((ctx[0].id & 0x10) == 0 ? Exp.Type.MAP.code : Exp.Type.LIST.code);
        return new Exp.Module(bin, bytes, retType, 64);
    }

    private static Exp addRead(Exp bin, byte[] bytes, Exp.Type retType) {
        return new Exp.Module(bin, bytes, retType.code, 0);
    }

    private static Exp.Type getValueType(int returnType) {
        int t = returnType & 0xFFFEFFFF;
        switch (t) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return Exp.Type.LIST;
            }
            case 5: {
                return Exp.Type.INT;
            }
            case 7: {
                return Exp.Type.LIST;
            }
            case 13: {
                return Exp.Type.BOOL;
            }
        }
        throw new AerospikeException("Invalid ListReturnType: " + returnType);
    }

    protected static byte[] packRangeOperation(int command, int returnType, Exp begin, Exp end, CTX[] ctx) {
        Packer packer = new Packer();
        Pack.init(packer, ctx);
        packer.packArrayBegin(end != null ? 4 : 3);
        packer.packInt(command);
        packer.packInt(returnType);
        if (begin != null) {
            begin.pack(packer);
        } else {
            packer.packNil();
        }
        if (end != null) {
            end.pack(packer);
        }
        return packer.toByteArray();
    }
}

