/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.documentapi;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.documentapi.DocumentApiException;
import com.aerospike.documentapi.IAerospikeDocumentRepository;
import com.aerospike.documentapi.JsonPathObject;
import com.aerospike.documentapi.JsonPathParser;
import com.aerospike.documentapi.Utils;
import com.aerospike.documentapi.pathparts.PathPart;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AerospikeDocumentRepository
implements IAerospikeDocumentRepository {
    private final IAerospikeClient client;

    AerospikeDocumentRepository(IAerospikeClient client) {
        this.client = client;
    }

    @Override
    public Object get(Policy readPolicy, Key documentKey, String documentBinName, JsonPathObject jsonPathObject) throws DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            Record record = this.client.get(readPolicy, documentKey);
            if (record != null) {
                return record.getValue(documentBinName);
            }
        } else {
            Record r;
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                WritePolicy writePolicy = readPolicy == null ? null : new WritePolicy(readPolicy);
                r = this.client.operate(writePolicy, documentKey, new Operation[]{finalPathPart.toAerospikeGetOperation(documentBinName, ctxArray)});
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
            if (r != null) {
                return r.getValue(documentBinName);
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> get(Policy readPolicy, Key documentKey, Collection<String> documentBinNames, JsonPathObject jsonPathObject) throws DocumentApiException {
        HashMap<String, Object> results;
        block6: {
            Record r;
            block5: {
                results = new HashMap<String, Object>();
                if (jsonPathObject.getPathParts().size() != 0) break block5;
                Record record = this.client.get(readPolicy, documentKey);
                if (record == null) break block6;
                for (String binName : documentBinNames) {
                    results.put(binName, record.bins.get(binName));
                }
                break block6;
            }
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            Operation[] operations = (Operation[])documentBinNames.stream().map(bn -> finalPathPart.toAerospikeGetOperation((String)bn, ctxArray)).toArray(Operation[]::new);
            try {
                WritePolicy writePolicy = readPolicy == null ? null : new WritePolicy(readPolicy);
                r = this.client.operate(writePolicy, documentKey, operations);
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
            if (r != null) {
                for (Map.Entry entry : r.bins.entrySet()) {
                    results.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return results;
    }

    @Override
    public void put(WritePolicy writePolicy, Key documentKey, String documentBinName, JsonNode jsonNode) {
        this.client.put(writePolicy, documentKey, new Bin[]{Utils.createBinByJsonNodeType(documentBinName, jsonNode)});
    }

    @Override
    public void put(WritePolicy writePolicy, Key documentKey, String documentBinName, Object jsonObject, JsonPathObject jsonPathObject) throws DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            this.client.put(writePolicy, documentKey, new Bin[]{new Bin(documentBinName, jsonObject)});
        } else {
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                this.client.operate(writePolicy, documentKey, new Operation[]{finalPathPart.toAerospikePutOperation(documentBinName, jsonObject, ctxArray)});
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
        }
    }

    @Override
    public void put(WritePolicy writePolicy, Key documentKey, Collection<String> documentBinNames, Object jsonObject, JsonPathObject jsonPathObject) throws DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            Operation[] operations = (Operation[])documentBinNames.stream().map(bn -> {
                Bin bin = new Bin(bn, jsonObject);
                return Operation.put((Bin)bin);
            }).toArray(Operation[]::new);
            this.client.operate(writePolicy, documentKey, operations);
        } else {
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                Operation[] operations = (Operation[])documentBinNames.stream().map(bn -> finalPathPart.toAerospikePutOperation((String)bn, jsonObject, ctxArray)).toArray(Operation[]::new);
                this.client.operate(writePolicy, documentKey, operations);
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
        }
    }

    @Override
    public void put(WritePolicy writePolicy, Key documentKey, Map<String, Object> queryResults, JsonPathObject jsonPathObject) throws DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            Operation[] operations = (Operation[])queryResults.entrySet().stream().map(e -> {
                Bin bin = new Bin((String)e.getKey(), e.getValue());
                return Operation.put((Bin)bin);
            }).toArray(Operation[]::new);
            this.client.operate(writePolicy, documentKey, operations);
        } else {
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                Operation[] operations = (Operation[])queryResults.entrySet().stream().map(e -> finalPathPart.toAerospikePutOperation((String)e.getKey(), e.getValue(), ctxArray)).toArray(Operation[]::new);
                this.client.operate(writePolicy, documentKey, operations);
            }
            catch (AerospikeException e2) {
                throw DocumentApiException.toDocumentException(e2);
            }
        }
    }

    @Override
    public void append(WritePolicy writePolicy, Key documentKey, String documentBinName, String jsonPath, Object jsonObject, JsonPathObject jsonPathObject) throws JsonPathParser.ListException, DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            throw new JsonPathParser.ListException(jsonPath);
        }
        List<PathPart> pathPart = jsonPathObject.getPathParts();
        PathPart finalPathPart = JsonPathParser.extractLastPathPart(pathPart);
        CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
        try {
            this.client.operate(writePolicy, documentKey, new Operation[]{finalPathPart.toAerospikeAppendOperation(documentBinName, jsonObject, ctxArray)});
        }
        catch (AerospikeException e) {
            throw DocumentApiException.toDocumentException(e);
        }
    }

    @Override
    public void append(WritePolicy writePolicy, Key documentKey, Collection<String> documentBinNames, String jsonPath, Object jsonObject, JsonPathObject jsonPathObject) throws JsonPathParser.ListException, DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            throw new JsonPathParser.ListException(jsonPath);
        }
        List<PathPart> pathPart = jsonPathObject.getPathParts();
        PathPart finalPathPart = JsonPathParser.extractLastPathPart(pathPart);
        CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
        try {
            Operation[] operations = (Operation[])documentBinNames.stream().map(bn -> finalPathPart.toAerospikeAppendOperation((String)bn, jsonObject, ctxArray)).toArray(Operation[]::new);
            this.client.operate(writePolicy, documentKey, operations);
        }
        catch (AerospikeException e) {
            throw DocumentApiException.toDocumentException(e);
        }
    }

    @Override
    public void append(WritePolicy writePolicy, Key documentKey, Map<String, Object> queryResults, String jsonPath, JsonPathObject jsonPathObject) throws JsonPathParser.ListException, DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            throw new JsonPathParser.ListException(jsonPath);
        }
        List<PathPart> pathPart = jsonPathObject.getPathParts();
        PathPart finalPathPart = JsonPathParser.extractLastPathPart(pathPart);
        CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
        try {
            Operation[] operations = (Operation[])queryResults.entrySet().stream().map(e -> finalPathPart.toAerospikeAppendOperation((String)e.getKey(), e.getValue(), ctxArray)).toArray(Operation[]::new);
            this.client.operate(writePolicy, documentKey, operations);
        }
        catch (AerospikeException e2) {
            throw DocumentApiException.toDocumentException(e2);
        }
    }

    @Override
    public void delete(WritePolicy writePolicy, Key documentKey, String documentBinName, String jsonPath, JsonPathObject jsonPathObject) throws JsonPathParser.ListException, DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            HashMap emptyMap = new HashMap();
            this.client.put(writePolicy, documentKey, new Bin[]{new Bin(documentBinName, emptyMap)});
        } else {
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                this.client.operate(writePolicy, documentKey, new Operation[]{finalPathPart.toAerospikeDeleteOperation(documentBinName, ctxArray)});
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
        }
    }

    @Override
    public void delete(WritePolicy writePolicy, Key documentKey, Collection<String> documentBinNames, String jsonPath, JsonPathObject jsonPathObject) throws JsonPathParser.ListException, DocumentApiException {
        if (jsonPathObject.getPathParts().size() == 0) {
            Operation[] operations = (Operation[])documentBinNames.stream().map(x$0 -> MapOperation.clear((String)x$0, (CTX[])new CTX[0])).toArray(Operation[]::new);
            this.client.operate(writePolicy, documentKey, operations);
        } else {
            List<PathPart> pathPart = jsonPathObject.getPathParts();
            PathPart finalPathPart = JsonPathParser.extractLastPathPartAndModifyList(pathPart);
            CTX[] ctxArray = JsonPathParser.pathPartsToContextsArray(pathPart);
            try {
                Operation[] operations = (Operation[])documentBinNames.stream().map(bn -> finalPathPart.toAerospikeDeleteOperation((String)bn, ctxArray)).toArray(Operation[]::new);
                this.client.operate(writePolicy, documentKey, operations);
            }
            catch (AerospikeException e) {
                throw DocumentApiException.toDocumentException(e);
            }
        }
    }
}

