/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.documentapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonConverters {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static JsonNode convertStringToJsonNode(String jsonString) throws IOException {
        return (JsonNode)mapper.readValue(jsonString, JsonNode.class);
    }

    public static Map<String, Object> convertJsonNodeToMap(JsonNode jsonNode) {
        return (Map)mapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static List<Object> convertJsonNodeToList(JsonNode jsonNode) {
        return (List)mapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<List<Object>>(){});
    }

    public static String convertObjectToJsonString(Object object) throws JsonProcessingException {
        String resultJson = object instanceof List ? JsonConverters.convertListToJsonString((List)object) : JsonConverters.convertMapToJsonString((Map)object);
        return resultJson;
    }

    public static String convertMapToJsonString(Map<?, ?> map) throws JsonProcessingException {
        return mapper.writeValueAsString(map);
    }

    public static String convertListToJsonString(List<?> list) throws JsonProcessingException {
        return mapper.writeValueAsString(list);
    }
}

