/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.documentapi;

import com.aerospike.client.cdt.CTX;
import com.aerospike.documentapi.JsonPathObject;
import com.aerospike.documentapi.pathparts.ListPathPart;
import com.aerospike.documentapi.pathparts.MapPathPart;
import com.aerospike.documentapi.pathparts.PathPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonPathParser {
    static final String JSON_PATH_SEPARATOR = ".";
    static final String DOCUMENT_ROOT_TOKEN = "$";
    static final Pattern PATH_PATTERN = Pattern.compile("^([^\\[^\\]]*)(\\[(\\d+)\\])*$");
    static final Pattern INDEX_PATTERN = Pattern.compile("(\\[(\\d+)\\])");
    private final List<String> jsonPathQueryIndications = new ArrayList<String>(Arrays.asList("[*]", "..", "[?"));
    JsonPathObject jsonPathObject = new JsonPathObject();

    JsonPathParser() {
    }

    JsonPathObject parse(String jsonString) throws JsonParseException {
        if (jsonString.charAt(0) != '$') {
            throw new JsonPrefixException(jsonString);
        }
        StringTokenizer tokenizer = new StringTokenizer(jsonString, JSON_PATH_SEPARATOR);
        if (!tokenizer.nextToken().equals(DOCUMENT_ROOT_TOKEN)) {
            throw new JsonPrefixException(jsonString);
        }
        Integer index = this.getFirstIndexOfAQueryIndication(jsonString);
        if (index != null) {
            this.jsonPathObject.setRequiresJsonPathQuery(true);
            String aerospikePathPartsString = jsonString.substring(0, index);
            String jsonPathPathPartsString = jsonString.substring(index);
            this.jsonPathObject.setJsonPathSecondStepQuery(jsonPathPathPartsString);
            tokenizer = new StringTokenizer(aerospikePathPartsString, JSON_PATH_SEPARATOR);
            if (!tokenizer.nextToken().equals(DOCUMENT_ROOT_TOKEN)) {
                throw new JsonPrefixException(jsonString);
            }
        }
        while (tokenizer.hasMoreTokens()) {
            this.parsePathPart(tokenizer.nextToken());
        }
        return this.jsonPathObject;
    }

    private void parsePathPart(String pathPart) throws JsonParseException {
        Matcher keyMatcher = PATH_PATTERN.matcher(pathPart);
        if (!pathPart.contains("[") && !pathPart.contains("]")) {
            if (!pathPart.equals("*")) {
                this.jsonPathObject.addPathPart(new MapPathPart(pathPart));
            }
        } else if (keyMatcher.find()) {
            String key = keyMatcher.group(1);
            this.jsonPathObject.addPathPart(new MapPathPart(key));
            Matcher indexMatcher = INDEX_PATTERN.matcher(pathPart);
            while (indexMatcher.find()) {
                this.jsonPathObject.addPathPart(new ListPathPart(Integer.parseInt(indexMatcher.group(2))));
            }
        } else {
            throw new JsonPathException(pathPart);
        }
    }

    public static PathPart extractLastPathPart(List<PathPart> pathParts) {
        return pathParts.get(pathParts.size() - 1);
    }

    public static PathPart extractLastPathPartAndModifyList(List<PathPart> pathParts) {
        return pathParts.remove(pathParts.size() - 1);
    }

    public static CTX[] pathPartsToContextsArray(List<PathPart> pathParts) {
        Vector<CTX> contextList = new Vector<CTX>();
        for (PathPart pathPart : pathParts) {
            contextList.add(pathPart.toAerospikeContext());
        }
        return contextList.toArray(new CTX[contextList.size()]);
    }

    private Integer getFirstIndexOfAQueryIndication(String jsonPath) {
        return this.jsonPathQueryIndications.stream().map(jsonPath::indexOf).filter(index -> index > 0).min(Integer::compare).orElse(null);
    }

    public static class JsonPrefixException
    extends JsonParseException {
        JsonPrefixException(String s) {
            super(s);
        }

        @Override
        public String toString() {
            return this.jsonString + " should start with a $";
        }
    }

    public static class JsonPathException
    extends JsonParseException {
        JsonPathException(String s) {
            super(s);
        }

        @Override
        public String toString() {
            return this.jsonString + " does not match key[number] format";
        }
    }

    public static class ListException
    extends JsonParseException {
        ListException(String s) {
            super(s);
        }

        @Override
        public String toString() {
            return "You can't append to a document root";
        }
    }

    public static abstract class JsonParseException
    extends Exception {
        String jsonString;

        JsonParseException(String s) {
            this.jsonString = s;
        }
    }
}

