/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.documentapi.pathparts;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListOperation;
import com.aerospike.documentapi.pathparts.PathPart;
import com.aerospike.documentapi.pathparts.PathPartTypeEnum;
import java.util.Objects;

public class ListPathPart
extends PathPart {
    private final int listPosition;

    public ListPathPart(int listPosition) {
        this.listPosition = listPosition;
    }

    public int getListPosition() {
        return this.listPosition;
    }

    public int hashCode() {
        return Objects.hashCode(this.listPosition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListPathPart)) {
            return false;
        }
        ListPathPart that = (ListPathPart)obj;
        return this.listPosition == that.listPosition;
    }

    @Override
    public CTX toAerospikeContext() {
        return CTX.listIndex((int)this.listPosition);
    }

    @Override
    public Operation toAerospikeGetOperation(String binName, CTX[] contexts) {
        return ListOperation.getByIndex((String)binName, (int)this.listPosition, (int)7, (CTX[])contexts);
    }

    @Override
    public Operation toAerospikePutOperation(String binName, Object object, CTX[] contexts) {
        return ListOperation.set((String)binName, (int)this.listPosition, (Value)Value.get((Object)object), (CTX[])contexts);
    }

    @Override
    public Operation toAerospikeDeleteOperation(String binName, CTX[] contexts) {
        return ListOperation.removeByIndex((String)binName, (int)this.listPosition, (int)0, (CTX[])contexts);
    }

    @Override
    public PathPartTypeEnum getType() {
        return PathPartTypeEnum.LIST;
    }
}

