/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.documentapi.pathparts;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.documentapi.pathparts.PathPart;
import com.aerospike.documentapi.pathparts.PathPartTypeEnum;
import java.util.Objects;

public class MapPathPart
extends PathPart {
    private final String key;

    public MapPathPart(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapPathPart)) {
            return false;
        }
        MapPathPart that = (MapPathPart)obj;
        return this.key.equals(that.key);
    }

    @Override
    public CTX toAerospikeContext() {
        return CTX.mapKey((Value)Value.get((String)this.key));
    }

    @Override
    public Operation toAerospikeGetOperation(String binName, CTX[] contexts) {
        return MapOperation.getByKey((String)binName, (Value)Value.get((String)this.key), (int)7, (CTX[])contexts);
    }

    @Override
    public Operation toAerospikePutOperation(String binName, Object object, CTX[] contexts) {
        return MapOperation.put((MapPolicy)new MapPolicy(), (String)binName, (Value)Value.get((String)this.key), (Value)Value.get((Object)object), (CTX[])contexts);
    }

    @Override
    public Operation toAerospikeDeleteOperation(String binName, CTX[] contexts) {
        return MapOperation.removeByKey((String)binName, (Value)Value.get((String)this.key), (int)0, (CTX[])contexts);
    }

    @Override
    public PathPartTypeEnum getType() {
        return PathPartTypeEnum.MAP;
    }
}

