/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.Policy;
import com.aerospike.jdbc.AerospikeDatabaseMetadata;
import com.aerospike.jdbc.AerospikePreparedStatement;
import com.aerospike.jdbc.AerospikeStatement;
import com.aerospike.jdbc.sql.SimpleWrapper;
import com.aerospike.jdbc.sql.type.ByteArrayBlob;
import com.aerospike.jdbc.sql.type.StringClob;
import com.aerospike.jdbc.util.ConnectionParametersParser;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class AerospikeConnection
implements Connection,
SimpleWrapper {
    private static final Logger logger = Logger.getLogger(AerospikeConnection.class.getName());
    private static final ConnectionParametersParser parser = new ConnectionParametersParser();
    private final String url;
    private final Properties props;
    private final IAerospikeClient client;
    private volatile boolean readOnly = false;
    private final Properties clientInfo = new Properties();
    private volatile Map<String, Class<?>> typeMap = Collections.emptyMap();
    private volatile int holdability = 1;
    private final AtomicReference<String> schema = new AtomicReference<Object>(null);
    private volatile boolean closed;

    public AerospikeConnection(String url, Properties props) {
        this.url = url;
        this.props = props;
        Host[] hosts = parser.hosts(url);
        this.client = new AerospikeClient(parser.policy(url, props), hosts);
        this.schema.set(parser.schema(url));
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("nativeSQL is not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
    }

    @Override
    public boolean getAutoCommit() {
        return true;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback is not supported");
    }

    @Override
    public void close() {
        this.client.close();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        logger.info("getMetaData request");
        return new AerospikeDatabaseMetadata(this.url, this.props, this.client, this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!this.isValid(1)) {
            throw new SQLException("Cannot set read only mode on closed connection");
        }
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) {
        this.schema.set(catalog);
    }

    @Override
    public String getCatalog() {
        return this.schema.get();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 0) {
            throw new SQLFeatureNotSupportedException(String.format("Aerospike does not support transactions, so the only valid value here is TRANSACTION_NONE=%d", 0));
        }
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot set holdability on closed connection");
        }
        if (holdability != 1 && holdability != 2) {
            throw new SQLException(String.format("Unsupported holdability %d. Must be either HOLD_CURSORS_OVER_COMMIT=%d or CLOSE_CURSORS_AT_COMMIT=%d", holdability, 1, 2));
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() {
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Connection is not transactional");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Connection is not transactional");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Connection is not transactional");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Connection is not transactional");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateResultSetParameters(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new AerospikeStatement(this.client, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateResultSetParameters(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new AerospikePreparedStatement(this.client, this, sql);
    }

    private void validateResultSetParameters(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("ResultSet type other than TYPE_FORWARD_ONLY is not supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Updatable ResultSet is not supported yet");
        }
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLException(String.format("Wrong value for the resultSetHoldability (%d). Supported values are: HOLD_CURSORS_OVER_COMMIT=%d or CLOSE_CURSORS_AT_COMMIT=%d", resultSetHoldability, 1, 2));
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() {
        return new StringClob();
    }

    @Override
    public Blob createBlob() {
        return new ByteArrayBlob();
    }

    @Override
    public NClob createNClob() {
        return new StringClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML is not supported");
    }

    @Override
    public boolean isValid(int timeout) {
        return this.client.isConnected() && Objects.nonNull(this.client.getClusterStats());
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) {
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    @Override
    public String getClientInfo(String name) {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return this.schema.get();
    }

    @Override
    public void abort(Executor executor) {
        executor.execute(this::close);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
        Arrays.stream(new Policy[]{this.client.getReadPolicyDefault(), this.client.getWritePolicyDefault(), this.client.getScanPolicyDefault(), this.client.getQueryPolicyDefault(), this.client.getBatchPolicyDefault()}).forEach(p -> {
            p.totalTimeout = milliseconds;
        });
        this.client.getInfoPolicyDefault().timeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() {
        return this.client.getReadPolicyDefault().totalTimeout;
    }
}

