/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.jdbc.AerospikeDriver;
import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.schema.AerospikeSchemaBuilder;
import com.aerospike.jdbc.sql.ListRecordSet;
import com.aerospike.jdbc.sql.SimpleWrapper;
import com.aerospike.jdbc.util.ConnectionParametersParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AerospikeDatabaseMetadata
implements DatabaseMetaData,
SimpleWrapper {
    private static final Logger logger = Logger.getLogger(AerospikeDatabaseMetadata.class.getName());
    private static final ConnectionParametersParser parser = new ConnectionParametersParser();
    private final String url;
    private final Properties clientInfo;
    private final Connection connection;
    private final InfoPolicy infoPolicy;
    private static final String newLine = System.lineSeparator();
    private final String dbBuild;
    private final String dbEdition;
    private final List<String> catalogs;
    private final Map<String, Collection<String>> tables = new ConcurrentHashMap<String, Collection<String>>();
    private final Map<String, Collection<IndexInfo>> indices = new ConcurrentHashMap<String, Collection<IndexInfo>>();

    public AerospikeDatabaseMetadata(String url, Properties info, IAerospikeClient client, Connection connection) {
        logger.info("Init AerospikeDatabaseMetadata");
        AerospikeSchemaBuilder.cleanSchemaCache();
        this.url = url;
        this.clientInfo = parser.clientInfo(url, info);
        this.connection = connection;
        this.infoPolicy = client.getInfoPolicyDefault();
        Set<String> builds = Collections.synchronizedSet(new HashSet());
        Set<String> editions = Collections.synchronizedSet(new HashSet());
        Set namespaces = Collections.synchronizedSet(new HashSet());
        ((Stream)Arrays.stream(client.getNodes()).parallel()).map(node -> Info.request((InfoPolicy)this.infoPolicy, (Node)node, (String[])new String[]{"namespaces", "sets", "sindex-list:", "build", "edition"})).forEach(r -> {
            builds.add((String)r.get("build"));
            editions.add((String)r.get("edition"));
            namespaces.addAll(Arrays.asList(this.getOrDefault((Map)r, (Object)"namespaces", (Object)"").split(";")));
            this.streamOfSubProperties((Map<String, String>)r, "sets").forEach(p -> this.tables.computeIfAbsent(p.getProperty("ns"), s -> new HashSet()).add(p.getProperty("set")));
            this.streamOfSubProperties((Map<String, String>)r, "sindex-list:").forEach(p -> this.indices.computeIfAbsent(p.getProperty("ns"), s -> new HashSet()).add(new IndexInfo(p.getProperty("ns"), p.getProperty("set"), p.getProperty("indexname"), p.getProperty("bin"), p.getProperty("type"))));
        });
        this.dbBuild = this.join("N/A", ", ", builds);
        this.dbEdition = this.join("Aerospike", ", ", editions);
        this.catalogs = namespaces.stream().filter(n -> !"".equals(n)).collect(Collectors.toList());
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.clientInfo.getProperty("user");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return this.dbEdition;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.dbBuild;
    }

    @Override
    public String getDriverName() {
        return AerospikeDriver.class.getName();
    }

    @Override
    public String getDriverVersion() {
        return "NA";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return "sum,sumsqs,avg,min,max,count";
    }

    @Override
    public String getStringFunctions() {
        return null;
    }

    @Override
    public String getSystemFunctions() {
        return null;
    }

    @Override
    public String getTimeDateFunctions() {
        return null;
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "";
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return "namespace";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 14;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 14;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 1;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 256;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 14;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 14;
    }

    @Override
    public int getMaxRowSize() {
        return 0x800000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 63;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 63;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 0 == level;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        String[] columns = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "reserved1", "reserved2", "reserved3", "REMARKS", "PROCEDURE_TYPE"};
        int[] sqlTypes = new int[]{12, 12, 12, 1, 1, 1, 12, 5};
        return new ListRecordSet(null, "system", "procedures", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        String[] columns = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 5, 4, 12, 4, 5, 5, 5, 12, 12, 4, 4, 4, 4, 12, 12, 12};
        return new ListRecordSet(null, "system", "procedure_columns", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        Pattern tableNameRegex = tableNamePattern == null || "".equals(tableNamePattern) ? null : Pattern.compile(tableNamePattern.replace("%", ".*"));
        Iterable tablesData = catalog == null ? (Iterable)this.tables.entrySet().stream().flatMap(p -> ((Collection)p.getValue()).stream().map(t -> Arrays.asList((String)p.getKey(), null, t, "TABLE", null, null, null, null, null, null))).collect(Collectors.toList()) : (Iterable)((Collection)this.tables.getOrDefault(catalog, Collections.emptyList())).stream().filter(t -> tableNameRegex == null || tableNameRegex.matcher((CharSequence)t).matches()).map(t -> Arrays.asList(catalog, null, t, "TABLE", null, null, null, null, null, null)).collect(Collectors.toList());
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        int[] sqlTypes = new int[columns.length];
        Arrays.fill(sqlTypes, 12);
        return new ListRecordSet(null, "system", "tables", this.systemColumns(columns, sqlTypes), tablesData);
    }

    @Override
    public ResultSet getSchemas() {
        return new ListRecordSet(null, "system", "schemas", this.systemColumns(new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, new int[]{12, 12}), Collections.emptyList());
    }

    @Override
    public ResultSet getCatalogs() {
        Iterable catalogs = this.getCatalogNames().stream().map(Collections::singletonList).collect(Collectors.toList());
        return new ListRecordSet(null, "system", "catalogs", this.systemColumns(new String[]{"TABLE_CAT"}, new int[]{12}), catalogs);
    }

    public List<String> getCatalogNames() {
        return this.catalogs;
    }

    @Override
    public ResultSet getTableTypes() {
        return new ListRecordSet(null, "system", "table_types", this.systemColumns(new String[]{"TABLE_TYPE"}, new int[]{12}), Collections.singletonList(Collections.singletonList("TABLE")));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.info(String.format("AerospikeDatabaseMetadata getColumns; %s, %s, %s, %s", catalog, schemaPattern, tableNamePattern, columnNamePattern));
        Pattern tableNameRegex = tableNamePattern == null || "".equals(tableNamePattern) ? null : Pattern.compile(tableNamePattern.replace("%", ".*"));
        Iterable mds = catalog == null ? (Iterable)this.tables.entrySet().stream().flatMap(p -> ((Collection)p.getValue()).stream().map(t -> this.getMetadata((String)p.getKey(), (String)t))).collect(Collectors.toList()) : (Iterable)((Collection)this.tables.getOrDefault(catalog, Collections.emptyList())).stream().filter(t -> tableNameRegex == null || tableNameRegex.matcher((CharSequence)t).matches()).map(t -> this.getMetadata(catalog, (String)t)).collect(Collectors.toList());
        ArrayList result = new ArrayList();
        for (ResultSetMetaData md : mds) {
            int n = md.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                result.add(Arrays.asList("".equals(tableNamePattern) ? "" : md.getCatalogName(i), null, md.getTableName(1), md.getColumnName(i), md.getColumnType(i), md.getColumnTypeName(i), 0, 0, 0, 0, 1, null, null, md.getColumnType(i), 0, md.getColumnType(i) == 12 ? 131072 : 0, this.ordinal(md, md.getColumnName(i)), "YES", md.getCatalogName(i), null, md.getColumnTypeName(i), 0, "NO", "NO"));
            }
        }
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 5, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5, 12, 12};
        return new ListRecordSet(null, "system", "columns", this.systemColumns(columns, sqlTypes), result);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        return new ListRecordSet(null, "system", "column_privileges", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12, 12};
        return new ListRecordSet(null, "system", "table_privileges", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        String[] columns = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] sqlTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        return new ListRecordSet(null, "system", "best_row_identifier", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        String[] columns = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] sqlTypes = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        return new ListRecordSet(null, "system", "version_columns", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        Iterable tablesData = catalog == null ? (Iterable)this.tables.entrySet().stream().flatMap(p -> ((Collection)p.getValue()).stream().map(t -> Arrays.asList((Serializable)p.getKey(), null, t, "__key", 1, "__key"))).collect(Collectors.toList()) : (Iterable)((Collection)this.tables.getOrDefault(catalog, Collections.emptyList())).stream().filter(t -> table == null || table.equals(t)).map(t -> Arrays.asList(catalog, null, t, "__key", 1, "__key")).collect(Collectors.toList());
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 5, 12};
        return new ListRecordSet(null, "system", "primary_keys", this.systemColumns(columns, sqlTypes), tablesData);
    }

    public List<String> getTableNames(String catalog) {
        if (catalog == null) {
            return this.tables.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return new ArrayList<String>(this.tables.getOrDefault(catalog, Collections.emptyList()));
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        String[] columns = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        return new ListRecordSet(null, "system", "imported_keys", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        String[] columns = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        return new ListRecordSet(null, "system", "exported_keys", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        String[] columns = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        return new ListRecordSet(null, "system", "cross_references", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getTypeInfo() {
        String[] columns = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        List<List<?>> data = Arrays.asList(Arrays.asList("VARCHAR", 12, 65535, "'", "'", "(M) [CHARACTER SET charset_name] [COLLATE collation_name]", (short)1, true, (short)3, false, false, false, "string", (short)0, (short)0, 12, 0, 10), Arrays.asList("INT", 4, 3, "", "", "[(M)] [UNSIGNED] [ZEROFILL]", (short)1, true, (short)3, false, false, false, "integer", (short)0, (short)0, 4, 0, 10), Arrays.asList("DOUBLE", 8, 22, "", "", "[(M,D)] [UNSIGNED] [ZEROFILL]", (short)1, true, (short)3, false, false, false, "double", (short)0, (short)0, 8, 0, 10), Arrays.asList("BLOB", 2004, 65535, "", "", "[(M)]", (short)1, true, (short)3, false, false, false, "bytes", (short)0, (short)0, 2004, 0, 10), Arrays.asList("LIST", 2003, 0, "", "", "[(M)]", (short)1, true, (short)3, false, false, false, "bytes", (short)0, (short)0, 2004, 0, 10), Arrays.asList("MAP", JDBCType.OTHER, 0, "", "", "[(M)]", (short)1, true, (short)3, false, false, false, "bytes", (short)0, (short)0, JDBCType.OTHER, 0, 10), Arrays.asList("JAVA_OBJECT", 2000, 0, "", "", "[(M)]", (short)1, true, (short)3, false, false, false, "bytes", (short)0, (short)0, 2000, 0, 10));
        return new ListRecordSet(null, "system", "table_info", this.systemColumns(columns), data);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        Iterable indicesData = catalog == null ? (Iterable)this.indices.entrySet().stream().flatMap(p -> ((Collection)p.getValue()).stream()).map(IndexInfo::asList).collect(Collectors.toList()) : (Iterable)((Collection)this.getOrDefault(this.indices, catalog, Collections.emptyList())).stream().map(IndexInfo::asList).collect(Collectors.toList());
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] sqlTypes = new int[]{12, 12, 12, -6, 12, 12, 5, 5, 12, 12, -5, -5, 12};
        return new ListRecordSet(null, "system", "index_info", this.systemColumns(columns, sqlTypes), indicesData);
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        String[] columns = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 4, 12, 5};
        return new ListRecordSet(null, "system", "udt", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        List<List<?>> types = Arrays.asList(Arrays.asList(catalog, null, "list", null, null, Object.class.getName()), Arrays.asList(catalog, null, "map", null, null, Object.class.getName()), Arrays.asList(catalog, null, "GeoJSON", null, null, Object.class.getName()));
        String[] columns = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 12, 12};
        return new ListRecordSet(null, "system", "super_types", this.systemColumns(columns, sqlTypes), types);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12};
        return new ListRecordSet(null, "system", "super_tables", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        String[] columns = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5};
        return new ListRecordSet(null, "system", "attributes", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return 1 == holdability;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.parseVersion(this.getDatabaseProductVersion().split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() {
        String[] fragments = this.getDatabaseProductVersion().split("\\.");
        return this.parseVersion(fragments[fragments.length - 1]);
    }

    private int parseVersion(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        String[] columns = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
        int[] sqlTypes = new int[]{12, 12};
        return new ListRecordSet(null, "system", "schemas", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        String[] columns = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        int[] sqlTypes = new int[]{12, 4, 12, 12};
        return new ListRecordSet(null, "system", "client_inf_properties", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        ArrayList functions = new ArrayList();
        String[] columns = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "REMARKS", "FUNCTION_TYPE", "SPECIFIC_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 5, 12};
        return new ListRecordSet(null, "system", "functions", this.systemColumns(columns, sqlTypes), functions);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        String[] columns = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 5, 4, 12, 4, 4, 5, 5, 5, 12, 4, 4, 12, 12};
        return new ListRecordSet(null, "system", "function_columns", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "COLUMN_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "COLUMN_USAGE", "REMARKS", "CHAR_OCTET_LENGTH", "IS_NULLABLE"};
        int[] sqlTypes = new int[]{12, 12, 12, 12, 4, 4, 4, 4, 12, 12, 4, 12};
        return new ListRecordSet(null, "system", "pseudo_columns", this.systemColumns(columns, sqlTypes), Collections.emptyList());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    private List<DataColumn> systemColumns(String[] names) {
        return this.columns("system", null, names);
    }

    private List<DataColumn> columns(String catalog, String table, String[] names) {
        return IntStream.range(0, names.length).boxed().map(i -> new DataColumn(catalog, table, names[i], names[i])).collect(Collectors.toList());
    }

    private List<DataColumn> systemColumns(String[] names, int[] types) {
        return this.columns("system", null, names, types);
    }

    private List<DataColumn> columns(String catalog, String table, String[] names, int[] types) {
        return IntStream.range(0, names.length).boxed().map(i -> new DataColumn(catalog, table, names[i], names[i]).withType(types[i])).collect(Collectors.toList());
    }

    private Properties initProperties(String lines) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(lines));
        }
        catch (IOException e) {
            logger.warning(String.format("Expression in initProperties, lines: %s", lines));
        }
        return properties;
    }

    private Stream<Properties> streamOfSubProperties(Map<String, String> map, String key) {
        return Optional.ofNullable(map.get(key)).map(s -> Arrays.stream(s.split(";")).map(ns -> this.initProperties(ns.replace(":", newLine)))).orElse(Stream.empty());
    }

    private <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return Optional.ofNullable(map.getOrDefault(key, defaultValue)).orElse(defaultValue);
    }

    private String join(String defaultValue, String delimiter, Collection<String> elements) {
        return elements.isEmpty() ? defaultValue : String.join((CharSequence)delimiter, elements);
    }

    private int ordinal(ResultSetMetaData md, String columnName) {
        int ordinal = 0;
        try {
            int n = md.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!columnName.equals(md.getColumnName(i))) continue;
                ordinal = i;
                break;
            }
        }
        catch (SQLException e) {
            logger.severe(String.format("Exception in ordinal, columnName: %s", columnName));
        }
        return ordinal;
    }

    private ResultSetMetaData getMetadata(String namespace, String table) {
        try {
            return this.connection.createStatement().executeQuery(String.format("select * from %s.%s limit %d", namespace, table, 1000L)).getMetaData();
        }
        catch (SQLException e) {
            logger.severe(String.format("Exception in getMetadata, namespace: %s, table: %s", namespace, table));
            throw new RuntimeException(e);
        }
    }

    private class IndexInfo {
        private final String namespace;
        private final String set;
        private final String name;
        private final String bin;
        private final String type;

        private IndexInfo(String namespace, String set, String name, String bin, String type) {
            this.namespace = namespace;
            this.set = set;
            this.name = name;
            this.bin = bin;
            this.type = type;
        }

        public List<?> asList() {
            return Arrays.asList(this.namespace, null, this.set, 0, null, this.name, (short)1, AerospikeDatabaseMetadata.this.ordinal(AerospikeDatabaseMetadata.this.getMetadata(this.namespace, this.set), this.bin), this.bin, null, null, 0, null);
        }
    }
}

