/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc;

import com.aerospike.jdbc.AerospikeConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AerospikeDriver
implements Driver {
    private static final Logger logger = Logger.getLogger("com.aerospike.jdbc");

    @Override
    public Connection connect(String url, Properties info) {
        return new AerospikeConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        return Objects.nonNull(url) && url.startsWith("jdbc:aerospike:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        int questionPos = url.indexOf(63);
        ArrayList allInfo = new ArrayList();
        if (questionPos > 0 && questionPos < url.length() - 1) {
            Arrays.stream(url.substring(questionPos + 1).split("&")).forEach(p -> {
                String[] kv = p.split("=");
                allInfo.add(new DriverPropertyInfo(kv[0], kv.length > 1 ? kv[1] : null));
            });
        }
        allInfo.addAll(info.entrySet().stream().map(e -> new DriverPropertyInfo((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        return allInfo.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return logger;
    }

    static {
        try {
            DriverManager.registerDriver(new AerospikeDriver());
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError("Can not register AerospikeDriver");
        }
    }
}

