/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.model;

import com.aerospike.jdbc.model.SchemaTableName;
import java.util.Objects;

public class DataColumn {
    private String catalog;
    private String table;
    private final String name;
    private String label;
    private int type;

    public DataColumn(String catalog, String table, String name, String label) {
        this.catalog = catalog;
        this.table = table;
        this.name = name;
        this.label = label;
    }

    public DataColumn(String catalog, String table, int type, String name, String label) {
        this(catalog, table, name, label);
        this.type = type;
    }

    public DataColumn withCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public DataColumn withTable(String table) {
        this.table = table;
        return this;
    }

    public DataColumn withType(int type) {
        this.type = type;
        return this;
    }

    public DataColumn withLabel(String label) {
        this.label = label;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public int getType() {
        return this.type;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.catalog, this.table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataColumn that = (DataColumn)o;
        return this.type == that.type && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name) && Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.table, this.name, this.label, this.type);
    }
}

