/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.ExpressionFormatter;
import io.prestosql.sql.SqlFormatter;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.AllRows;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CurrentPath;
import io.prestosql.sql.tree.CurrentTime;
import io.prestosql.sql.tree.CurrentUser;
import io.prestosql.sql.tree.DateTimeDataType;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.Format;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericDataType;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IntervalDayTimeDataType;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.NumericParameter;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.RowDataType;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.TypeParameter;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.sql.tree.Window;
import io.prestosql.sql.tree.WindowFrame;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class AerospikeExpressionParser {
    private static final ThreadLocal<DecimalFormat> doubleFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("0.###################E0###", new DecimalFormatSymbols(Locale.US)));

    private AerospikeExpressionParser() {
    }

    public static String formatExpression(Expression expression) {
        return (String)new Formatter().process((Node)expression, null);
    }

    private static String formatIdentifier(String s) {
        return '\"' + s.replace("\"", "\"\"") + '\"';
    }

    static String formatStringLiteral(String s) {
        s = s.replace("'", "''");
        if (CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)s)) {
            return "'" + s + "'";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("U&'");
        PrimitiveIterator.OfInt iterator = s.codePoints().iterator();
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            Preconditions.checkArgument((codePoint >= 0 ? 1 : 0) != 0, (String)"Invalid UTF-8 encoding in characters: %s", (Object)s);
            if (AerospikeExpressionParser.isAsciiPrintable(codePoint)) {
                char ch = (char)codePoint;
                if (ch == '\\') {
                    builder.append(ch);
                }
                builder.append(ch);
                continue;
            }
            if (codePoint <= 65535) {
                builder.append('\\');
                builder.append(String.format("%04X", codePoint));
                continue;
            }
            builder.append("\\+");
            builder.append(String.format("%06X", codePoint));
        }
        builder.append("'");
        return builder.toString();
    }

    public static List<String> formatOrderBy(OrderBy orderBy) {
        return AerospikeExpressionParser.formatSortItems(orderBy.getSortItems());
    }

    private static List<String> formatSortItems(List<SortItem> sortItems) {
        return sortItems.stream().map(AerospikeExpressionParser.sortItemFormatterFunction()).collect(Collectors.toList());
    }

    private static boolean isAsciiPrintable(int codePoint) {
        return codePoint >= 32 && codePoint < 127;
    }

    private static String formatGroupingSet(List<Expression> groupingSet) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet.stream().map(ExpressionFormatter::formatExpression).iterator()));
    }

    private static Function<SortItem, String> sortItemFormatterFunction() {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(AerospikeExpressionParser.formatExpression(input.getSortKey()));
            switch (input.getOrdering()) {
                case ASCENDING: {
                    builder.append(" ASC");
                    break;
                }
                case DESCENDING: {
                    builder.append(" DESC");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ordering: " + input.getOrdering());
                }
            }
            switch (input.getNullOrdering()) {
                case FIRST: {
                    builder.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    builder.append(" NULLS LAST");
                }
                case UNDEFINED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown null ordering: " + input.getNullOrdering());
                }
            }
            return builder.toString();
        };
    }

    public static class Formatter
    extends AstVisitor<String, Void> {
        protected String visitNode(Node node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitRow(Row node, Void context) {
            return Joiner.on((String)", ").join((Iterable)node.getItems().stream().map(child -> (String)this.process((Node)child, context)).collect(Collectors.toList()));
        }

        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitAtTimeZone(AtTimeZone node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitCurrentUser(CurrentUser node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitCurrentPath(CurrentPath node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitFormat(Format node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitCurrentTime(CurrentTime node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitExtract(Extract node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return String.valueOf(node.getValue());
        }

        protected String visitStringLiteral(StringLiteral node, Void context) {
            return AerospikeExpressionParser.formatStringLiteral(node.getValue());
        }

        protected String visitCharLiteral(CharLiteral node, Void context) {
            return "CHAR " + AerospikeExpressionParser.formatStringLiteral(node.getValue());
        }

        protected String visitBinaryLiteral(BinaryLiteral node, Void context) {
            return "X'" + node.toHexString() + "'";
        }

        protected String visitParameter(Parameter node, Void context) {
            return "?";
        }

        protected String visitAllRows(AllRows node, Void context) {
            return "ALL";
        }

        protected String visitArrayConstructor(ArrayConstructor node, Void context) {
            ImmutableList.Builder valueStrings = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                valueStrings.add((Object)SqlFormatter.formatSql((Node)value));
            }
            return "ARRAY[" + Joiner.on((String)",").join((Iterable)valueStrings.build()) + "]";
        }

        protected String visitSubscriptExpression(SubscriptExpression node, Void context) {
            return SqlFormatter.formatSql((Node)node.getBase()) + "[" + SqlFormatter.formatSql((Node)node.getIndex()) + "]";
        }

        protected String visitLongLiteral(LongLiteral node, Void context) {
            return Long.toString(node.getValue());
        }

        protected String visitDoubleLiteral(DoubleLiteral node, Void context) {
            return ((DecimalFormat)doubleFormatter.get()).format(node.getValue());
        }

        protected String visitDecimalLiteral(DecimalLiteral node, Void context) {
            return "DECIMAL '" + node.getValue() + "'";
        }

        protected String visitGenericLiteral(GenericLiteral node, Void context) {
            return node.getType() + " " + AerospikeExpressionParser.formatStringLiteral(node.getValue());
        }

        protected String visitTimeLiteral(TimeLiteral node, Void context) {
            return "TIME '" + node.getValue() + "'";
        }

        protected String visitTimestampLiteral(TimestampLiteral node, Void context) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        protected String visitNullLiteral(NullLiteral node, Void context) {
            return "null";
        }

        protected String visitIntervalLiteral(IntervalLiteral node, Void context) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append(node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append(node.getEndField().get());
            }
            return builder.toString();
        }

        protected String visitSubqueryExpression(SubqueryExpression node, Void context) {
            return "(" + SqlFormatter.formatSql((Node)node.getQuery()) + ")";
        }

        protected String visitExists(ExistsPredicate node, Void context) {
            return "(EXISTS " + SqlFormatter.formatSql((Node)node.getSubquery()) + ")";
        }

        protected String visitIdentifier(Identifier node, Void context) {
            return !node.isDelimited() ? node.getValue() : '\"' + node.getValue().replace("\"", "\"\"") + '\"';
        }

        protected String visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, Void context) {
            return ExpressionFormatter.formatExpression((Expression)node.getName());
        }

        protected String visitSymbolReference(SymbolReference node, Void context) {
            return AerospikeExpressionParser.formatIdentifier(node.getName());
        }

        protected String visitDereferenceExpression(DereferenceExpression node, Void context) {
            String baseString = (String)this.process((Node)node.getBase(), context);
            return baseString + "." + (String)this.process((Node)node.getField());
        }

        public String visitFieldReference(FieldReference node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitFunctionCall(FunctionCall node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitLambdaExpression(LambdaExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitBindExpression(BindExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().toString(), node.getLeft(), node.getRight());
        }

        protected String visitNotExpression(NotExpression node, Void context) {
            return "(NOT " + (String)this.process((Node)node.getValue(), context) + ")";
        }

        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        protected String visitIsNullPredicate(IsNullPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IS NULL)";
        }

        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IS NOT NULL)";
        }

        protected String visitNullIfExpression(NullIfExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitIfExpression(IfExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitTryExpression(TryExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitCoalesceExpression(CoalesceExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitLikePredicate(LikePredicate node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process((Node)node.getValue(), context)).append(" LIKE ").append((String)this.process((Node)node.getPattern(), context));
            node.getEscape().ifPresent(escape -> builder.append(" ESCAPE ").append((String)this.process((Node)escape, context)));
            builder.append(')');
            return builder.toString();
        }

        protected String visitAllColumns(AllColumns node, Void context) {
            StringBuilder builder = new StringBuilder();
            if (node.getTarget().isPresent()) {
                builder.append((String)this.process((Node)node.getTarget().get(), context));
                builder.append(".*");
            } else {
                builder.append("*");
            }
            if (!node.getAliases().isEmpty()) {
                builder.append(" AS (");
                Joiner.on((String)", ").appendTo(builder, (Iterable)node.getAliases().stream().map(alias -> (String)this.process((Node)alias, context)).collect(Collectors.toList()));
                builder.append(")");
            }
            return builder.toString();
        }

        public String visitCast(Cast node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitWhenClause(WhenClause node, Void context) {
            return "WHEN " + (String)this.process((Node)node.getOperand(), context) + " THEN " + (String)this.process((Node)node.getResult(), context);
        }

        protected String visitBetweenPredicate(BetweenPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " BETWEEN " + (String)this.process((Node)node.getMin(), context) + " AND " + (String)this.process((Node)node.getMax(), context) + ")";
        }

        protected String visitInPredicate(InPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IN " + (String)this.process((Node)node.getValueList(), context) + ")";
        }

        protected String visitInListExpression(InListExpression node, Void context) {
            return "(" + this.joinExpressions(node.getValues()) + ")";
        }

        private String visitFilter(Expression node, Void context) {
            return "(WHERE " + (String)this.process((Node)node, context) + ')';
        }

        public String visitWindow(Window node, Void context) {
            throw new UnsupportedOperationException();
        }

        public String visitWindowFrame(WindowFrame node, Void context) {
            throw new UnsupportedOperationException();
        }

        public String visitFrameBound(FrameBound node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + ' ' + node.getOperator().getValue() + ' ' + node.getQuantifier().toString() + ' ' + (String)this.process((Node)node.getSubquery(), context) + ")";
        }

        protected String visitGroupingOperation(GroupingOperation node, Void context) {
            return "GROUPING (" + this.joinExpressions(node.getGroupingColumns()) + ")";
        }

        protected String visitRowDataType(RowDataType node, Void context) {
            return node.getFields().stream().map(arg_0 -> ((Formatter)this).process(arg_0)).collect(Collectors.joining(", ", "ROW(", ")"));
        }

        protected String visitRowField(RowDataType.Field node, Void context) {
            StringBuilder result = new StringBuilder();
            if (node.getName().isPresent()) {
                result.append((String)this.process((Node)node.getName().get(), context));
                result.append(" ");
            }
            result.append((String)this.process((Node)node.getType(), context));
            return result.toString();
        }

        protected String visitGenericDataType(GenericDataType node, Void context) {
            StringBuilder result = new StringBuilder();
            result.append(node.getName());
            if (!node.getArguments().isEmpty()) {
                result.append(node.getArguments().stream().map(arg_0 -> ((Formatter)this).process(arg_0)).collect(Collectors.joining(", ", "(", ")")));
            }
            return result.toString();
        }

        protected String visitTypeParameter(TypeParameter node, Void context) {
            return (String)this.process((Node)node.getValue(), context);
        }

        protected String visitNumericTypeParameter(NumericParameter node, Void context) {
            return node.getValue();
        }

        protected String visitIntervalDataType(IntervalDayTimeDataType node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("INTERVAL ");
            builder.append(node.getFrom());
            if (node.getFrom() != node.getTo()) {
                builder.append(" TO ").append(node.getTo());
            }
            return builder.toString();
        }

        protected String visitDateTimeType(DateTimeDataType node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString().toLowerCase(Locale.ENGLISH));
            if (node.getPrecision().isPresent()) {
                builder.append("(").append(node.getPrecision().get()).append(")");
            }
            if (node.isWithTimeZone()) {
                builder.append(" with time zone");
            }
            return builder.toString();
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return left + operator + right;
        }

        private String joinExpressions(List<Expression> expressions) {
            throw new UnsupportedOperationException();
        }
    }
}

