/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Value;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.query.ExpressionBuilder;
import com.aerospike.jdbc.query.QueryHandler;
import com.aerospike.jdbc.sql.ListRecordSet;
import com.aerospike.jdbc.util.IOUtils;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class BaseQueryHandler
implements QueryHandler {
    protected final IAerospikeClient client;
    protected final Statement statement;

    public BaseQueryHandler(IAerospikeClient client, Statement statement) {
        this.client = client;
        this.statement = statement;
    }

    protected Bin[] getBins(AerospikeQuery query) {
        ArrayList<Bin> bins = new ArrayList<Bin>();
        List<String> columns = query.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            bins.add(new Bin(IOUtils.stripQuotes(columns.get(i)), this.getBinValue(query.getValues().get(i))));
        }
        return bins.toArray(new Bin[0]);
    }

    protected Value getBinValue(String strValue) {
        if (ExpressionBuilder.isStringValue(strValue)) {
            return Value.get((String)ExpressionBuilder.stripQuotes(strValue));
        }
        try {
            return new Value.LongValue(Long.parseLong(strValue));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Value.DoubleValue(Double.parseDouble(strValue));
            }
            catch (NumberFormatException numberFormatException2) {
                if (strValue.toLowerCase(Locale.ENGLISH).equals("null")) {
                    return Value.NULL;
                }
                return Value.get((String)strValue);
            }
        }
    }

    protected ListRecordSet emptyRecordSet(AerospikeQuery query) {
        return new ListRecordSet(this.statement, query.getSchema(), query.getTable(), Collections.emptyList(), Collections.emptyList());
    }
}

