/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.Value;
import com.aerospike.client.exp.Exp;
import com.aerospike.jdbc.model.OpType;
import com.aerospike.jdbc.model.Pair;
import com.aerospike.jdbc.model.WhereExpression;
import java.util.Objects;
import java.util.function.BiFunction;

public final class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    public static Value fetchPrimaryKey(WhereExpression whereExpression) {
        if (Objects.nonNull(whereExpression) && !whereExpression.isWrapper() && whereExpression.getColumn().equals("__key")) {
            Object value = whereExpression.getValue();
            if (ExpressionBuilder.isStringValue(value.toString())) {
                return Value.get((String)ExpressionBuilder.stripQuotes(value.toString()));
            }
            return Value.get((Object)value);
        }
        return null;
    }

    public static Exp buildExp(WhereExpression whereExpression) {
        if (Objects.isNull(whereExpression)) {
            return null;
        }
        if (whereExpression.isWrapper()) {
            OpType opType = whereExpression.getOpType();
            switch (opType) {
                case OR: {
                    return Exp.or((Exp[])((Exp[])whereExpression.getInner().stream().map(ExpressionBuilder::buildExp).toArray(Exp[]::new)));
                }
                case AND: {
                    return Exp.and((Exp[])((Exp[])whereExpression.getInner().stream().map(ExpressionBuilder::buildExp).toArray(Exp[]::new)));
                }
                case NOT: {
                    return Exp.not((Exp)((Exp[])whereExpression.getInner().stream().map(ExpressionBuilder::buildExp).toArray(Exp[]::new))[0]);
                }
            }
            throw new IllegalArgumentException("Unexpected OpType: " + (Object)((Object)whereExpression.getOpType()));
        }
        return ExpressionBuilder.buildComparisonExpession(whereExpression);
    }

    private static Exp buildComparisonExpession(WhereExpression whereExpression) {
        OpType opType = whereExpression.getOpType();
        switch (opType) {
            case LIKE: {
                return Exp.regexCompare((String)whereExpression.getValue().toString(), (int)10, (Exp)Exp.stringBin((String)whereExpression.getColumn()));
            }
            case EQUALS: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::eq);
            }
            case NOT_EQUALS: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::ne);
            }
            case LESS: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::lt);
            }
            case LESS_EQUALS: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::le);
            }
            case GREATER: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::gt);
            }
            case GREATER_EQUALS: {
                return ExpressionBuilder.getComparableExpression(whereExpression, Exp::ge);
            }
            case NOT_NULL: {
                return Exp.binExists((String)whereExpression.getColumn());
            }
            case NULL: {
                return Exp.eq((Exp)Exp.binType((String)whereExpression.getColumn()), (Exp)Exp.val((long)0L));
            }
        }
        throw new IllegalArgumentException("Unexpected OpType: " + (Object)((Object)whereExpression.getOpType()));
    }

    private static Exp getComparableExpression(WhereExpression whereExpression, BiFunction<Exp, Exp, Exp> expFunc) {
        Pair<Exp, Exp> exps = ExpressionBuilder.parseComparable(whereExpression);
        return expFunc.apply(exps.getLeft(), exps.getRight());
    }

    private static Pair<Exp, Exp> parseComparable(WhereExpression whereExpression) {
        if (ExpressionBuilder.isStringValue(whereExpression.getValue().toString())) {
            return new Pair<Exp, Exp>(Exp.stringBin((String)whereExpression.getColumn()), Exp.val((String)ExpressionBuilder.stripQuotes(whereExpression.getValue().toString())));
        }
        return new Pair<Exp, Exp>(Exp.intBin((String)whereExpression.getColumn()), Exp.val((long)Long.parseLong(whereExpression.getValue().toString())));
    }

    public static boolean isStringValue(String value) {
        return value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'");
    }

    public static String stripQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

