/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.model.Pair;
import com.aerospike.jdbc.query.BaseQueryHandler;
import com.aerospike.jdbc.query.PolicyBuilder;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class InsertQueryHandler
extends BaseQueryHandler {
    public InsertQueryHandler(IAerospikeClient client, Statement statement) {
        super(client, statement);
    }

    @Override
    public Pair<ResultSet, Integer> execute(AerospikeQuery query) {
        Value queryKey = this.extractInsertKey(query);
        if (Objects.isNull(queryKey)) {
            queryKey = this.generateRandomKey();
        }
        Key key = new Key(query.getSchema(), query.getTable(), queryKey);
        Bin[] bins = this.getBins(query);
        try {
            this.client.put(PolicyBuilder.buildCreateOnlyPolicy(query), key, bins);
        }
        catch (AerospikeException e) {
            return new Pair<ResultSet, Integer>(this.emptyRecordSet(query), 0);
        }
        return new Pair<ResultSet, Integer>(this.emptyRecordSet(query), 1);
    }

    private Value extractInsertKey(AerospikeQuery query) {
        List<String> columns = query.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).equals("__key")) continue;
            String key = query.getValues().get(i);
            columns.remove(i);
            query.getValues().remove(i);
            return this.getBinValue(key);
        }
        return null;
    }

    private Value generateRandomKey() {
        return Value.get((String)UUID.randomUUID().toString());
    }
}

