/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.model.Pair;
import com.aerospike.jdbc.query.DeleteQueryHandler;
import com.aerospike.jdbc.query.InsertQueryHandler;
import com.aerospike.jdbc.query.SelectQueryHandler;
import com.aerospike.jdbc.query.TruncateQueryHandler;
import com.aerospike.jdbc.query.UpdateQueryHandler;
import java.sql.ResultSet;
import java.sql.Statement;

public final class QueryPerformer {
    public static Pair<ResultSet, Integer> executeQuery(IAerospikeClient client, Statement statement, AerospikeQuery query) {
        switch (query.getType()) {
            case SELECT: {
                SelectQueryHandler queryHandler = new SelectQueryHandler(client, statement);
                return queryHandler.execute(query);
            }
            case INSERT: {
                InsertQueryHandler queryHandler = new InsertQueryHandler(client, statement);
                return queryHandler.execute(query);
            }
            case UPDATE: {
                UpdateQueryHandler queryHandler = new UpdateQueryHandler(client, statement);
                return queryHandler.execute(query);
            }
            case DELETE: {
                DeleteQueryHandler queryHandler = new DeleteQueryHandler(client, statement);
                return queryHandler.execute(query);
            }
            case DROP_TABLE: {
                TruncateQueryHandler queryHandler = new TruncateQueryHandler(client, statement);
                return queryHandler.execute(query);
            }
        }
        throw new RuntimeException("Unsupported query type");
    }
}

