/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.model.Pair;
import com.aerospike.jdbc.query.BaseQueryHandler;
import com.aerospike.jdbc.query.ExpressionBuilder;
import com.aerospike.jdbc.query.PolicyBuilder;
import com.aerospike.jdbc.scan.PartitionScanHandler;
import com.aerospike.jdbc.scan.RecordSet;
import com.aerospike.jdbc.schema.AerospikeSchemaBuilder;
import com.aerospike.jdbc.sql.AerospikeRecordResultSet;
import com.aerospike.jdbc.util.AerospikeUtils;
import com.aerospike.jdbc.util.IOUtils;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SelectQueryHandler
extends BaseQueryHandler {
    private static final Logger logger = Logger.getLogger(SelectQueryHandler.class.getName());
    protected List<DataColumn> columns;

    public SelectQueryHandler(IAerospikeClient client, Statement statement) {
        super(client, statement);
    }

    @Override
    public Pair<ResultSet, Integer> execute(AerospikeQuery query) {
        this.columns = AerospikeSchemaBuilder.getSchema(query.getSchemaTable(), this.client);
        Value pk = ExpressionBuilder.fetchPrimaryKey(query.getWhere());
        Pair<ResultSet, Integer> result = this.isCount(query) ? this.executeCountQuery(query) : (Objects.nonNull(pk) ? this.executeSelectByPrimaryKey(query, pk) : this.executeScanQuery(query));
        return result;
    }

    private Pair<ResultSet, Integer> executeCountQuery(AerospikeQuery query) {
        RecordSet recordSet;
        int recordNumber;
        logger.info("SELECT count");
        String countLabel = query.getColumns().get(0);
        if (Objects.isNull(query.getWhere())) {
            recordNumber = AerospikeUtils.getTableRecordsNumber(this.client, query.getSchema(), query.getTable());
        } else {
            ScanPolicy policy = PolicyBuilder.buildScanNoBinDataPolicy(query);
            recordSet = PartitionScanHandler.create(this.client).scanPartition(policy, query);
            AtomicInteger count = new AtomicInteger();
            recordSet.forEach(r -> count.incrementAndGet());
            recordNumber = count.get();
        }
        Record record = new Record(Collections.singletonMap(countLabel, recordNumber), 1, 0);
        recordSet = new RecordSet(2);
        recordSet.put(new KeyRecord(null, record));
        recordSet.end();
        List<DataColumn> columnList = Collections.singletonList(new DataColumn(query.getSchema(), query.getTable(), 4, countLabel, countLabel));
        return new Pair<ResultSet, Integer>(new AerospikeRecordResultSet(recordSet, this.statement, query.getSchema(), query.getTable(), columnList), -1);
    }

    private Pair<ResultSet, Integer> executeSelectByPrimaryKey(AerospikeQuery query, Value primaryKey) {
        RecordSet recordSet;
        logger.info("SELECT PK");
        Key key = new Key(query.getSchema(), query.getTable(), primaryKey);
        Record record = this.client.get(null, key, query.getBinNames());
        if (Objects.nonNull(record)) {
            recordSet = new RecordSet(2);
            KeyRecord keyRecord = new KeyRecord(key, record);
            recordSet.put(keyRecord);
        } else {
            recordSet = new RecordSet(1);
        }
        recordSet.end();
        return new Pair<ResultSet, Integer>(new AerospikeRecordResultSet(recordSet, this.statement, query.getSchema(), query.getTable(), this.filterColumns(this.columns, query.getBinNames())), -1);
    }

    private Pair<ResultSet, Integer> executeScanQuery(AerospikeQuery query) {
        logger.info("SELECT scan");
        ScanPolicy policy = PolicyBuilder.buildScanPolicy(query);
        RecordSet recordSet = PartitionScanHandler.create(this.client).scanPartition(policy, query);
        return new Pair<ResultSet, Integer>(new AerospikeRecordResultSet(recordSet, this.statement, query.getSchema(), query.getTable(), this.filterColumns(this.columns, query.getBinNames())), -1);
    }

    private boolean isCount(AerospikeQuery query) {
        return query.getColumns().size() == 1 && query.getColumns().get(0).toLowerCase(Locale.ENGLISH).startsWith("count(");
    }

    private List<DataColumn> filterColumns(List<DataColumn> columns, String[] selected) {
        if (Objects.isNull(selected)) {
            return columns;
        }
        List list = Arrays.stream(selected).map(IOUtils::stripQuotes).collect(Collectors.toList());
        return columns.stream().filter(c -> list.contains(c.getName())).collect(Collectors.toList());
    }
}

