/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.model.Pair;
import com.aerospike.jdbc.query.BaseQueryHandler;
import com.aerospike.jdbc.query.ExpressionBuilder;
import com.aerospike.jdbc.query.PolicyBuilder;
import com.aerospike.jdbc.scan.EventLoopProvider;
import com.aerospike.jdbc.scan.ScanRecordSequenceListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class UpdateQueryHandler
extends BaseQueryHandler {
    private static final Logger logger = Logger.getLogger(UpdateQueryHandler.class.getName());

    public UpdateQueryHandler(IAerospikeClient client, Statement statement) {
        super(client, statement);
    }

    @Override
    public Pair<ResultSet, Integer> execute(AerospikeQuery query) {
        logger.info("UPDATE statement");
        Value keyObject = ExpressionBuilder.fetchPrimaryKey(query.getWhere());
        Bin[] bins = this.getBins(query);
        WritePolicy writePolicy = PolicyBuilder.buildUpdateOnlyPolicy(query);
        if (Objects.nonNull(keyObject)) {
            Key key = new Key(query.getSchema(), query.getTable(), Value.get((Object)keyObject));
            try {
                this.client.put(writePolicy, key, bins);
            }
            catch (AerospikeException e) {
                return new Pair<ResultSet, Integer>(this.emptyRecordSet(query), 0);
            }
            return new Pair<ResultSet, Integer>(this.emptyRecordSet(query), 1);
        }
        ScanRecordSequenceListener listener = new ScanRecordSequenceListener();
        ScanPolicy scanPolicy = PolicyBuilder.buildScanPolicy(query);
        scanPolicy.includeBinData = false;
        this.client.scanAll(EventLoopProvider.getEventLoop(), (RecordSequenceListener)listener, scanPolicy, query.getSchema(), query.getTable(), new String[0]);
        AtomicInteger count = new AtomicInteger();
        listener.getRecordSet().forEach(r -> {
            try {
                this.client.put(writePolicy, r.key, bins);
                count.incrementAndGet();
            }
            catch (AerospikeException aerospikeException) {
                // empty catch block
            }
        });
        return new Pair<ResultSet, Integer>(this.emptyRecordSet(query), count.get());
    }
}

