/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.scan;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionFilter;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.scan.RecordSet;
import com.aerospike.jdbc.scan.ScanRecordSequenceListener;
import java.util.Objects;
import java.util.logging.Logger;

public class PartitionScanHandler {
    private static final Logger logger = Logger.getLogger(PartitionScanHandler.class.getName());
    private final IAerospikeClient client;
    private ScanRecordSequenceListener listener;
    private int currentPartition;
    private int count;
    private final ScanCallback callback = (key, record) -> {
        this.listener.onRecord(key, record);
        ++this.count;
    };

    public PartitionScanHandler(IAerospikeClient client) {
        this.client = client;
        this.listener = new ScanRecordSequenceListener();
    }

    public RecordSet scanPartition(ScanPolicy scanPolicy, AerospikeQuery query) {
        if (Objects.nonNull(query.getOffset())) {
            long maxRecords = scanPolicy.maxRecords;
            PartitionFilter filter = this.getPartitionFilter(query);
            while (this.isScanRequired(maxRecords)) {
                this.client.scanPartitions(scanPolicy, filter, query.getSchema(), query.getTable(), this.callback, query.getBinNames());
                scanPolicy.maxRecords = maxRecords > 0L ? maxRecords - (long)this.count : maxRecords;
                filter = PartitionFilter.id((int)(++this.currentPartition));
            }
            this.listener.onSuccess();
        } else {
            logger.info("scanAll");
            this.client.scanAll(null, (RecordSequenceListener)this.listener, scanPolicy, query.getSchema(), query.getTable(), query.getBinNames());
        }
        return this.listener.getRecordSet();
    }

    private PartitionFilter getPartitionFilter(AerospikeQuery query) {
        Key key = new Key(query.getSchema(), query.getTable(), query.getOffset().intValue());
        this.currentPartition = Partition.getPartitionId((byte[])key.digest);
        return PartitionFilter.after((Key)key);
    }

    private boolean isScanRequired(long maxRecords) {
        return (maxRecords == 0L || (long)this.count < maxRecords) && this.isValidPartition();
    }

    private boolean isValidPartition() {
        return this.currentPartition >= 0 && this.currentPartition < 4096;
    }

    public static PartitionScanHandler create(IAerospikeClient client) {
        return new PartitionScanHandler(client);
    }
}

