/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.schema;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Value;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.model.SchemaTableName;
import com.aerospike.jdbc.schema.AerospikeSchemaCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class AerospikeSchemaBuilder {
    private static final Logger logger = Logger.getLogger(AerospikeSchemaBuilder.class.getName());
    private static final Duration cacheTTL = Duration.ofMinutes(30L);
    private static final AerospikeSchemaCache cache = new AerospikeSchemaCache(cacheTTL);

    private AerospikeSchemaBuilder() {
    }

    public static void cleanSchemaCache() {
        cache.clear();
    }

    public static List<DataColumn> getSchema(SchemaTableName schemaTableName, IAerospikeClient client) {
        return cache.get(schemaTableName).orElseGet(() -> {
            logger.info("Fetching SchemaTableName: " + schemaTableName);
            TreeMap<String, DataColumn> columnHandles = new TreeMap<String, DataColumn>(String::compareToIgnoreCase);
            ScanPolicy policy = new ScanPolicy();
            policy.maxRecords = 1000L;
            columnHandles.put("__key", new DataColumn(schemaTableName.getSchemaName(), schemaTableName.getTableName(), 12, "__key", "__key"));
            client.scanAll(policy, schemaTableName.getSchemaName(), AerospikeSchemaBuilder.toSet(schemaTableName.getTableName()), (key, record) -> {
                Map bins = record.bins;
                bins.forEach((k, value) -> {
                    logger.fine(String.format("Bin: %s -> %s", k, value));
                    int t = AerospikeSchemaBuilder.getBinType(value);
                    if (t != 0) {
                        columnHandles.put((String)k, new DataColumn(schemaTableName.getSchemaName(), schemaTableName.getTableName(), t, (String)k, (String)k));
                    }
                });
            }, new String[0]);
            ArrayList<DataColumn> columns = new ArrayList<DataColumn>(columnHandles.values());
            cache.put(schemaTableName, (List<DataColumn>)columns);
            return columns;
        });
    }

    private static String toSet(String tableName) {
        if (tableName.equals("__default")) {
            return null;
        }
        return tableName;
    }

    private static int getBinType(Object value) {
        int t = 0;
        if (value instanceof byte[] || value instanceof Value.BytesValue || value instanceof Value.ByteSegmentValue) {
            t = -3;
        } else if (value instanceof String || value instanceof Value.StringValue) {
            t = 12;
        } else if (value instanceof Integer || value instanceof Value.IntegerValue) {
            t = 4;
        } else if (value instanceof Long || value instanceof Value.LongValue) {
            t = -5;
        } else if (value instanceof Double || value instanceof Value.DoubleValue) {
            t = 8;
        } else if (value instanceof Float || value instanceof Value.FloatValue) {
            t = 6;
        } else if (value instanceof Boolean || value instanceof Value.BooleanValue) {
            t = 16;
        } else if (value instanceof Byte || value instanceof Value.ByteValue) {
            t = -6;
        } else if (value instanceof Value.HLLValue) {
            t = 2004;
        } else if (value instanceof Value.GeoJSONValue) {
            t = 2004;
        } else if (value instanceof List || value instanceof Value.ListValue) {
            t = 2003;
        } else if (value instanceof Map || value instanceof Value.MapValue) {
            t = 2002;
        } else {
            logger.info("Unknown bin type: " + value);
        }
        return t;
    }
}

