/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql;

import com.aerospike.client.Record;
import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.scan.RecordSet;
import com.aerospike.jdbc.sql.BaseResultSet;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class AerospikeRecordResultSet
extends BaseResultSet<Record> {
    private static final Logger logger = Logger.getLogger(AerospikeRecordResultSet.class.getName());
    private final RecordSet recordSet;

    public AerospikeRecordResultSet(RecordSet recordSet, Statement statement, String schema, String table, List<DataColumn> columns) {
        super(statement, schema, table, columns);
        this.recordSet = recordSet;
    }

    @Override
    protected Record getRecord() {
        return this.recordSet.getRecord();
    }

    @Override
    protected boolean moveToNext() {
        return this.recordSet.next();
    }

    @Override
    public Object getObject(String columnLabel) {
        logger.fine("getObject: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return this.recordSet.getKey().userKey;
        }
        return this.recordSet.getRecord().bins.get(columnLabel);
    }

    @Override
    public String getString(String columnLabel) {
        logger.fine("getString: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return this.recordSet.getKey().userKey.toString();
        }
        Object bin = this.recordSet.getRecord().bins.get(columnLabel);
        return Objects.isNull(bin) ? null : bin.toString();
    }

    @Override
    public boolean getBoolean(String columnLabel) {
        logger.fine("getBoolean: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return Boolean.parseBoolean(this.recordSet.getKey().userKey.toString());
        }
        return Boolean.parseBoolean(this.recordSet.getRecord().bins.get(columnLabel).toString());
    }

    @Override
    public byte getByte(String columnLabel) {
        logger.fine("getByte: " + columnLabel);
        return 0;
    }

    @Override
    public short getShort(String columnLabel) {
        logger.fine("getShort: " + columnLabel);
        return (short)this.getInt(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) {
        logger.fine("getInt: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return this.recordSet.getKey().userKey.toInteger();
        }
        return Integer.parseInt(this.recordSet.getRecord().bins.get(columnLabel).toString());
    }

    @Override
    public long getLong(String columnLabel) {
        logger.fine("getLong: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return this.recordSet.getKey().userKey.toLong();
        }
        return Long.parseLong(this.recordSet.getRecord().bins.get(columnLabel).toString());
    }

    @Override
    public float getFloat(String columnLabel) {
        logger.fine("getFloat: " + columnLabel);
        return (float)this.getDouble(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) {
        logger.fine("getDouble: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return Double.parseDouble(this.recordSet.getKey().userKey.toString());
        }
        return Double.parseDouble(this.recordSet.getRecord().bins.get(columnLabel).toString());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        logger.fine("getBigDecimal: " + columnLabel);
        return BigDecimal.valueOf(this.getLong(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) {
        logger.fine("getBytes: " + columnLabel);
        if (columnLabel.equals("__key")) {
            return this.recordSet.getKey().userKey.toString().getBytes();
        }
        return (byte[])this.recordSet.getRecord().bins.get(columnLabel);
    }
}

