/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql;

import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.sql.SimpleWrapper;
import com.aerospike.jdbc.util.SqlLiterals;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class AerospikeResultSetMetaData
implements ResultSetMetaData,
SimpleWrapper {
    private static final Logger logger = Logger.getLogger(AerospikeResultSetMetaData.class.getName());
    private static final int MAX_BLOCK_SIZE = 131072;
    private static final int MAX_DATE_SIZE = 32;
    public static final Map<Integer, Integer> precisionByType = new HashMap<Integer, Integer>();
    private final String schema;
    private final String table;
    private final List<DataColumn> columns;

    public AerospikeResultSetMetaData(String schema, String table, List<DataColumn> columns) {
        this.schema = schema;
        this.table = table;
        this.columns = Collections.unmodifiableList(columns);
    }

    public List<DataColumn> getColumns() {
        return this.columns;
    }

    private Stream<DataColumn> getVisibleColumns() {
        return this.columns.stream();
    }

    @Override
    public int getColumnCount() {
        logger.fine("getColumnCount: " + this.getVisibleColumns().count());
        return (int)this.getVisibleColumns().count();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 1;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return 32;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) {
        logger.fine("getColumnName: " + column);
        return this.columns.get(column - 1).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (this.columns.isEmpty()) {
            throw new SQLException("invalidColumnIndex: " + column);
        }
        return this.schema;
    }

    @Override
    public int getPrecision(int column) {
        return precisionByType.getOrDefault(this.getColumnType(column), 0);
    }

    @Override
    public int getScale(int column) {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.columns.isEmpty()) {
            throw new SQLException("invalidColumnIndex: " + column);
        }
        return this.table;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.columns.isEmpty()) {
            throw new SQLException("invalidColumnIndex: " + column);
        }
        return this.schema;
    }

    @Override
    public int getColumnType(int column) {
        return this.columns.get(column - 1).getType();
    }

    @Override
    public String getColumnTypeName(int column) {
        return SqlLiterals.sqlTypeNames.get(this.getColumnType(column));
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return true;
    }

    @Override
    public String getColumnClassName(int column) {
        return SqlLiterals.sqlToJavaTypes.get(this.getColumnType(column)).getName();
    }

    static {
        precisionByType.put(-7, 8);
        precisionByType.put(-6, 8);
        precisionByType.put(5, 8);
        precisionByType.put(4, 8);
        precisionByType.put(-5, 8);
        precisionByType.put(6, 8);
        precisionByType.put(7, 8);
        precisionByType.put(8, 8);
        precisionByType.put(2, 8);
        precisionByType.put(3, 8);
        precisionByType.put(1, 2);
        precisionByType.put(12, 131072);
        precisionByType.put(-1, 131072);
        precisionByType.put(91, 32);
        precisionByType.put(92, 32);
        precisionByType.put(93, 32);
        precisionByType.put(-2, 131072);
        precisionByType.put(-3, 131072);
        precisionByType.put(-4, 131072);
        precisionByType.put(0, 0);
        precisionByType.put(1111, 131072);
        precisionByType.put(2000, 131072);
        precisionByType.put(2001, 131072);
        precisionByType.put(2002, 131072);
        precisionByType.put(2003, 131072);
        precisionByType.put(2004, 131072);
        precisionByType.put(2005, 131072);
        precisionByType.put(2006, 0);
        precisionByType.put(70, 0);
        precisionByType.put(16, 8);
        precisionByType.put(-8, 0);
        precisionByType.put(-15, 2);
        precisionByType.put(-9, 131072);
        precisionByType.put(-16, 131072);
        precisionByType.put(2011, 131072);
        precisionByType.put(2009, 131072);
        precisionByType.put(2012, 0);
        precisionByType.put(2013, 32);
        precisionByType.put(2014, 32);
    }
}

