/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql;

import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.sql.AerospikeResultSetMetaData;
import com.aerospike.jdbc.sql.IndexToLabelResultSet;
import com.aerospike.jdbc.sql.SimpleWrapper;
import com.aerospike.jdbc.sql.UpdateResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public abstract class BaseResultSet<T>
implements ResultSet,
IndexToLabelResultSet,
UpdateResultSet,
SimpleWrapper {
    private static final Logger logger = Logger.getLogger(BaseResultSet.class.getName());
    private final Statement statement;
    protected final String schema;
    protected final String table;
    private boolean wasNull = false;
    protected volatile int index;
    private volatile boolean closed;
    protected boolean afterLast = false;
    protected final List<DataColumn> columns;
    private final ResultSetMetaData metadata;

    public BaseResultSet(Statement statement, String schema, String table, List<DataColumn> columns) {
        this.statement = statement;
        this.schema = schema;
        this.table = table;
        this.columns = Collections.unmodifiableList(columns);
        this.metadata = new AerospikeResultSetMetaData(schema, table, columns);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return IntStream.range(0, this.columns.size()).filter(i -> columnLabel.equals(this.columns.get(i).getName())).map(i -> i + 1).findFirst().orElseThrow(() -> new SQLException(String.format("Column %s does not exist", columnLabel)));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return BigDecimal.valueOf(this.getDouble(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.afterLast;
    }

    @Override
    public boolean isFirst() {
        return this.index == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.index != 0) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        while (this.next()) {
        }
        this.afterLast = true;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.index == 0) {
            return this.next();
        }
        throw new SQLException("Cannot rewind result set");
    }

    protected abstract T getRecord();

    @Override
    public boolean last() throws SQLException {
        T lastRecord;
        if (this.isAfterLast()) {
            return false;
        }
        do {
            lastRecord = this.getRecord();
        } while (this.next());
        if (lastRecord != null) {
            this.afterLast = false;
            this.setCurrentRecord(lastRecord);
            return true;
        }
        return false;
    }

    protected void setCurrentRecord(T record) {
    }

    @Override
    public int getRow() {
        return this.afterLast ? 0 : this.index;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.relative(row - this.index);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int n = Math.abs(rows);
        for (int i = 0; i < n; ++i) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getNClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) {
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            String spec = this.getString(columnLabel);
            return spec != null ? new URL(spec) : null;
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) {
        return this.getCharacterStream(columnLabel);
    }

    public <U> U getObject(String columnLabel, Class<U> type) {
        return null;
    }

    protected void assertClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Result set is closed");
        }
    }

    protected abstract boolean moveToNext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        BaseResultSet baseResultSet = this;
        synchronized (baseResultSet) {
            this.assertClosed();
            boolean result = this.moveToNext();
            if (result) {
                this.clearWarnings();
                ++this.index;
            } else {
                this.afterLast = true;
            }
            return result;
        }
    }
}

