/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql;

import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.sql.BaseResultSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ListRecordSet
extends BaseResultSet<List<?>> {
    private static final Logger logger = Logger.getLogger(ListRecordSet.class.getName());
    private final Iterator<List<?>> it;
    private final Map<String, Integer> nameToIndex;
    private List<?> currentRecord = null;

    public ListRecordSet(Statement statement, String schema, String table, List<DataColumn> columns, Iterable<List<?>> data) {
        super(statement, schema, table, columns);
        this.it = data.iterator();
        this.nameToIndex = IntStream.range(0, columns.size()).boxed().collect(Collectors.toMap(i -> ((DataColumn)columns.get((int)i)).getName(), i -> i));
    }

    @Override
    protected List<?> getRecord() {
        return this.currentRecord;
    }

    protected Object getValue(String columnLabel) {
        return this.getRecord().get(this.nameToIndex.get(columnLabel));
    }

    @Override
    public String getString(String columnLabel) {
        Object value = this.getValue(columnLabel);
        return Objects.isNull(value) ? "" : value.toString();
    }

    @Override
    public boolean getBoolean(String columnLabel) {
        return Boolean.parseBoolean(this.getValue(columnLabel).toString());
    }

    @Override
    public byte getByte(String columnLabel) {
        return (Byte)this.getValue(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) {
        return (Short)this.getValue(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) {
        String strVal = null;
        try {
            strVal = this.getValue(columnLabel).toString();
            return Integer.parseInt(strVal);
        }
        catch (Exception e) {
            logger.warning("getInt Exception for " + columnLabel + ", " + strVal);
            return -1;
        }
    }

    @Override
    public long getLong(String columnLabel) {
        String strVal = null;
        try {
            strVal = this.getValue(columnLabel).toString();
            return Long.parseLong(strVal);
        }
        catch (Exception e) {
            logger.warning("getLong Exception for " + columnLabel + ", " + strVal);
            return -1L;
        }
    }

    @Override
    public float getFloat(String columnLabel) {
        return ((Float)this.getValue(columnLabel)).floatValue();
    }

    @Override
    public double getDouble(String columnLabel) {
        return (Double)this.getValue(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal");
    }

    @Override
    public byte[] getBytes(String columnLabel) {
        return (byte[])this.getValue(columnLabel);
    }

    @Override
    public boolean isLast() {
        return !this.it.hasNext();
    }

    @Override
    protected boolean moveToNext() {
        boolean hasNext = this.it.hasNext();
        this.currentRecord = hasNext ? this.it.next() : null;
        return hasNext;
    }

    @Override
    protected void setCurrentRecord(List<?> record) {
        this.currentRecord = record;
    }
}

