/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql.type;

import com.aerospike.jdbc.model.DataColumn;
import com.aerospike.jdbc.util.SqlLiterals;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialException;

public class BasicArray
extends SerialArray {
    private String schema;
    private final List<DataColumn> columns;

    public BasicArray(Array array, Map<String, Class<?>> map) throws SQLException {
        super(array, map);
        this.columns = this.columns(array.getBaseType());
    }

    public BasicArray(Array array) throws SQLException {
        super(array);
        this.columns = this.columns(array.getBaseType());
    }

    public BasicArray(String schema, final String baseTypeName, final Object[] elements) throws SQLException {
        super(new Array(){
            private final int baseType;
            {
                this.baseType = Optional.ofNullable(SqlLiterals.sqlTypeByName.get(baseTypeName)).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported array type %s", baseTypeName)));
            }

            @Override
            public String getBaseTypeName() {
                return baseTypeName;
            }

            @Override
            public int getBaseType() {
                return this.baseType;
            }

            @Override
            public Object getArray() {
                return elements;
            }

            @Override
            public Object getArray(Map<String, Class<?>> map) {
                return elements;
            }

            @Override
            public Object getArray(long index, int count) {
                return elements;
            }

            @Override
            public Object getArray(long index, int count, Map<String, Class<?>> map) {
                return elements;
            }

            @Override
            public ResultSet getResultSet() {
                throw new IllegalStateException();
            }

            @Override
            public ResultSet getResultSet(Map<String, Class<?>> map) {
                throw new IllegalStateException();
            }

            @Override
            public ResultSet getResultSet(long index, int count) {
                throw new IllegalStateException();
            }

            @Override
            public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) {
                throw new IllegalStateException();
            }

            @Override
            public void free() {
                throw new IllegalStateException();
            }
        });
        this.schema = schema;
        this.columns = this.columns(this.getBaseType());
    }

    private List<DataColumn> columns(int baseType) {
        return Arrays.asList(new DataColumn(this.schema, null, "INDEX", "INDEX").withType(4), new DataColumn(this.schema, null, "VALUE", "VALUE").withType(baseType));
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SerialException {
        return this.getResultSet(index, count, Collections.emptyMap());
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SerialException {
        return this.getResultSet(0L, Integer.MAX_VALUE, map);
    }

    @Override
    public ResultSet getResultSet() throws SerialException {
        return this.getResultSet(0L, Integer.MAX_VALUE, Collections.emptyMap());
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SerialException {
        AtomicInteger counter = new AtomicInteger((int)index);
        Iterable data = Arrays.stream((Object[])this.getArray()).skip(index).map(e -> Arrays.asList(counter.incrementAndGet(), e)).collect(Collectors.toList());
        return null;
    }
}

