/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class ByteArrayBlob
implements Blob {
    private static final byte[] EMPTY = new byte[0];
    private volatile byte[] data;

    public ByteArrayBlob() {
        this(EMPTY);
    }

    public ByteArrayBlob(byte[] data) {
        this.data = data;
    }

    @Override
    public long length() {
        return this.data.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        if (length < 0) {
            throw new SQLException(String.format("Length must be >= 0 but was %d", length));
        }
        int from = (int)pos - 1;
        return Arrays.copyOfRange(this.data, from, from + length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start > this.length()) {
            return -1L;
        }
        int index = ByteArrayBlob.indexOf(this.data, (int)start - 1, this.data.length, pattern, 0, pattern.length, 0);
        return index >= 0 ? (long)(index + 1) : (long)index;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(((ByteArrayBlob)pattern).data, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        if (offset < 0) {
            throw new SQLException(String.format("Offset cannot be negative but was %d", offset));
        }
        int blobOffset = (int)pos - 1;
        int n = blobOffset + bytes.length - offset;
        byte[] newData = new byte[n];
        System.arraycopy(this.data, 0, newData, 0, blobOffset);
        System.arraycopy(bytes, offset, newData, blobOffset, bytes.length - offset);
        this.data = newData;
        return n;
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    ByteArrayBlob.this.setBytes(pos, this.toByteArray());
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len > Integer.MAX_VALUE || len < 1L) {
            throw new SQLException(String.format("Length must be between 0 and %d but was %d", Integer.MAX_VALUE, len));
        }
        byte[] newData = Arrays.copyOf(this.data, (int)len);
        this.data = newData;
    }

    @Override
    public void free() {
        this.data = EMPTY;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(pos, (int)length));
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.data, ((ByteArrayBlob)o).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

