/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.sql.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Objects;

public class StringClob
implements NClob {
    private String data;

    public StringClob() {
        this("");
    }

    public StringClob(String data) {
        this.data = data;
    }

    @Override
    public long length() {
        return this.data.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        int from = (int)pos - 1;
        return this.data.substring(from, from + length);
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.data);
    }

    @Override
    public InputStream getAsciiStream() {
        return new ByteArrayInputStream(this.data.getBytes());
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start > Integer.MAX_VALUE || start < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, start));
        }
        int from = (int)start - 1;
        int foundIndex = this.data.indexOf(searchstr, from);
        return foundIndex < 0 ? (long)foundIndex : (long)(foundIndex + 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(((StringClob)searchstr).data, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        if (offset < 0) {
            throw new SQLException(String.format("Offset cannot be negative but was %d", offset));
        }
        int till = (int)pos;
        this.data = (this.data.length() >= till ? this.data.substring(0, till) : this.data) + str.substring(offset, offset + len);
        return len - offset;
    }

    @Override
    public OutputStream setAsciiStream(final long pos) throws SQLException {
        if (pos > Integer.MAX_VALUE || pos < 1L) {
            throw new SQLException(String.format("Position must be between 1 and %d but was %d", Integer.MAX_VALUE, pos));
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    StringClob.this.setString(pos, new String(this.toByteArray()));
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long pos) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    StringClob.this.setString(pos, this.getBuffer().toString());
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public void truncate(long len) {
        this.data = this.data.substring(0, (int)len);
    }

    @Override
    public void free() {
        this.data = "";
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new StringReader(this.getSubString(pos, (int)length));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.data, ((StringClob)o).data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

