/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.util;

import com.aerospike.jdbc.AerospikeStatement;
import com.aerospike.jdbc.model.AerospikeQuery;
import com.aerospike.jdbc.model.QueryType;
import com.aerospike.jdbc.query.AerospikeQueryParser;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AuxStatementParser {
    private static final Pattern updateSetWherePattern;
    private static final Pattern updateSetPattern;
    private static final Pattern truncateTablePattern;

    private AuxStatementParser() {
    }

    public static Optional<AerospikeQuery> hack(String sql) {
        Matcher m = updateSetWherePattern.matcher(sql);
        if (m.find()) {
            String queryString = "select * from " + m.group(1) + " where " + m.group(3);
            return Optional.of(AuxStatementParser.buildQuery(queryString, m.group(2)));
        }
        m = updateSetPattern.matcher(sql);
        if (m.find()) {
            String queryString = "select * from " + m.group(1);
            return Optional.of(AuxStatementParser.buildQuery(queryString, m.group(2)));
        }
        m = truncateTablePattern.matcher(sql);
        if (m.find()) {
            AerospikeQuery query = new AerospikeQuery();
            query.setType(QueryType.DROP_TABLE);
            query.setTable(m.group(1));
            return Optional.of(query);
        }
        return Optional.empty();
    }

    private static AerospikeQuery buildQuery(String queryString, String setString) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Arrays.stream(setString.split(",")).map(String::trim).forEach(s -> {
            String[] arr = s.split("=");
            columns.add(arr[0]);
            values.add(arr[1]);
        });
        Statement statement = AerospikeStatement.SQL_PARSER.createStatement(queryString, AerospikeStatement.parsingOptions);
        AerospikeQuery query = AerospikeQueryParser.parseSql((Node)statement);
        query.setColumns(columns);
        query.setValues(values);
        query.setType(QueryType.UPDATE);
        return query;
    }

    static {
        String p1 = "update (.*) set (.*) where (.*)";
        updateSetWherePattern = Pattern.compile(p1, 2);
        String p2 = "update (.*) set (.*)";
        updateSetPattern = Pattern.compile(p2, 2);
        String p3 = "truncate table (.*)";
        truncateTablePattern = Pattern.compile(p3, 2);
    }
}

