/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.util;

import com.aerospike.client.Host;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.jdbc.scan.EventLoopProvider;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConnectionParametersParser {
    private static final String defaultAerospikePort = "3000";
    private static final Pattern AS_JDBC_URL = Pattern.compile("^jdbc:aerospike:(?://)?([^/?]+)");
    private static final Pattern AS_JDBC_SCHEMA = Pattern.compile("/([^?]+)");

    public ClientPolicy policy(String url, Properties info) {
        ClientPolicy policy = new ClientPolicy();
        policy.eventLoops = EventLoopProvider.getEventLoops();
        return ConnectionParametersParser.copy(this.clientInfo(url, info), policy);
    }

    public static <T> T copy(Properties props, T object) {
        Class<?> clazz = object.getClass();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            try {
                clazz.getField((String)key).set(object, value);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }));
        return object;
    }

    public Host[] hosts(String url) {
        Matcher m = AS_JDBC_URL.matcher(url);
        if (!m.find()) {
            throw new IllegalArgumentException("Cannot parse URL " + url);
        }
        return (Host[])Arrays.stream(m.group(1).split(",")).map(p -> p.split(":")).map(a -> {
            String[] stringArray;
            if (((String[])a).length > 1) {
                stringArray = a;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = a[0];
                stringArray = stringArray2;
                stringArray2[1] = defaultAerospikePort;
            }
            return stringArray;
        }).map(hostPort -> new Host(hostPort[0], Integer.parseInt(hostPort[1]))).toArray(Host[]::new);
    }

    public String schema(String url) {
        Matcher m = AS_JDBC_SCHEMA.matcher(url);
        return m.find() ? m.group(1) : null;
    }

    public Properties clientInfo(String url, Properties info) {
        Properties all = new Properties();
        all.putAll((Map<?, ?>)info);
        int questionPos = url.indexOf(63);
        if (questionPos > 0 && questionPos < url.length() - 1) {
            Arrays.stream(url.substring(questionPos + 1).split("&")).forEach(p -> {
                String[] kv = p.split("=");
                if (kv.length > 1) {
                    all.setProperty(kv[0], kv[1]);
                }
            });
        }
        return all;
    }

    public Properties subProperties(Properties properties, String prefix) {
        String filter = prefix.endsWith(".") ? prefix : prefix + ".";
        int prefixLength = filter.length();
        Properties result = new Properties();
        result.putAll(properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(filter)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefixLength), Map.Entry::getValue)));
        return result;
    }

    public Collection<String> indexesParser(String infos) {
        return this.indexesParser(infos, "type", "ns", "set", "bin", "indexname");
    }

    public Collection<String> indexesParser(String infos, String ... propNames) {
        return Arrays.stream(infos.split(";")).filter(info -> !info.isEmpty()).map(info -> new StringReader(info.replace(":", "\n"))).map(r -> {
            Properties props = new Properties();
            try {
                props.load((Reader)r);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return props;
        }).map(p -> String.join((CharSequence)".", (CharSequence[])Arrays.stream(propNames).map(p::getProperty).toArray(String[]::new))).collect(Collectors.toSet());
    }
}

