/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PreparedStatementUtil {
    public static final char PS_PLACEHOLDER_PREFIX = '_';

    private PreparedStatementUtil() {
    }

    public static Map.Entry<String, Integer> parseParameters(String sql, int offset) {
        StringBuilder fixedIndexSqlBuf = new StringBuilder();
        int count = 0;
        boolean intoConstant = false;
        for (char c : sql.toCharArray()) {
            if (c == '\'') {
                boolean bl = intoConstant = !intoConstant;
            }
            if (!intoConstant && c == '?') {
                fixedIndexSqlBuf.append('_').append(++count + offset);
                continue;
            }
            fixedIndexSqlBuf.append(c);
        }
        return Collections.singletonMap(fixedIndexSqlBuf.toString(), count).entrySet().iterator().next();
    }

    public static Iterable<String> splitQueries(String sql) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder currentQuery = new StringBuilder();
        boolean intoConstant = false;
        for (char c : sql.toCharArray()) {
            if (c == '\'') {
                boolean bl = intoConstant = !intoConstant;
            }
            if (!intoConstant && c == ';') {
                PreparedStatementUtil.appendNotEmpty(queries, currentQuery.toString());
                currentQuery.setLength(0);
                continue;
            }
            currentQuery.append(c);
        }
        if (currentQuery.length() > 0 && currentQuery.toString().trim().length() > 0) {
            PreparedStatementUtil.appendNotEmpty(queries, currentQuery.toString());
        }
        return queries;
    }

    private static void appendNotEmpty(Collection<String> queries, String query) {
        if (query.trim().length() > 0) {
            queries.add(query);
        }
    }
}

