/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.jdbc.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SqlLiterals {
    public static final Map<Class<?>, Integer> sqlTypes = new HashMap();
    public static final Map<Integer, String> sqlTypeNames;
    public static final Map<String, Integer> sqlTypeByName;
    public static final Map<Integer, Class<?>> sqlToJavaTypes;

    public static int getSqlType(Object value) {
        return value == null ? 0 : SqlLiterals.getSqlType(value.getClass());
    }

    public static int getSqlType(Class<?> clazz) {
        return clazz == null ? 0 : sqlTypes.getOrDefault(clazz, 1111);
    }

    static {
        sqlTypes.put(Short.class, 5);
        sqlTypes.put(Integer.class, 4);
        sqlTypes.put(Long.class, -5);
        sqlTypes.put(Boolean.class, 16);
        sqlTypes.put(Float.class, 6);
        sqlTypes.put(Double.class, 8);
        sqlTypes.put(Short.TYPE, 5);
        sqlTypes.put(Integer.TYPE, 4);
        sqlTypes.put(Long.TYPE, -5);
        sqlTypes.put(Boolean.TYPE, 16);
        sqlTypes.put(Float.TYPE, 6);
        sqlTypes.put(Double.TYPE, 8);
        sqlTypes.put(String.class, 12);
        sqlTypes.put(byte[].class, 2004);
        sqlTypes.put(Date.class, 91);
        sqlTypes.put(Time.class, 92);
        sqlTypes.put(Timestamp.class, 93);
        sqlTypes.put(ArrayList.class, 2003);
        sqlTypes.put(null, 0);
        sqlTypes.put(Object.class, 1111);
        sqlTypeNames = new HashMap<Integer, String>();
        sqlTypeNames.put(5, "short");
        sqlTypeNames.put(4, "integer");
        sqlTypeNames.put(-5, "long");
        sqlTypeNames.put(16, "boolean");
        sqlTypeNames.put(6, "float");
        sqlTypeNames.put(8, "double");
        sqlTypeNames.put(12, "varchar");
        sqlTypeNames.put(2004, "blob");
        sqlTypeNames.put(91, "date");
        sqlTypeNames.put(92, "time");
        sqlTypeNames.put(93, "timestamp");
        sqlTypeNames.put(2003, "list");
        sqlTypeByName = sqlTypeNames.entrySet().stream().filter(name -> (Integer)name.getKey() != 2003).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1, TreeMap::new));
        sqlToJavaTypes = new HashMap();
        sqlToJavaTypes.put(5, Short.class);
        sqlToJavaTypes.put(4, Integer.class);
        sqlToJavaTypes.put(-5, Long.class);
        sqlToJavaTypes.put(16, Boolean.class);
        sqlToJavaTypes.put(6, Float.class);
        sqlToJavaTypes.put(8, Double.class);
        sqlToJavaTypes.put(12, String.class);
        sqlToJavaTypes.put(-1, String.class);
        sqlToJavaTypes.put(2004, byte[].class);
        sqlToJavaTypes.put(-2, byte[].class);
        sqlToJavaTypes.put(-3, byte[].class);
        sqlToJavaTypes.put(-4, byte[].class);
        sqlToJavaTypes.put(91, Date.class);
        sqlToJavaTypes.put(92, Time.class);
        sqlToJavaTypes.put(93, Timestamp.class);
    }
}

