/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.reactor;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.client.reactor.dto.KeyExists;
import com.aerospike.client.reactor.dto.KeyObject;
import com.aerospike.client.reactor.dto.KeysExists;
import com.aerospike.client.reactor.dto.KeysRecords;
import com.aerospike.client.reactor.listeners.ReactorBatchListListener;
import com.aerospike.client.reactor.listeners.ReactorBatchSequenceListener;
import com.aerospike.client.reactor.listeners.ReactorDeleteListener;
import com.aerospike.client.reactor.listeners.ReactorExecuteListener;
import com.aerospike.client.reactor.listeners.ReactorExistsArrayListener;
import com.aerospike.client.reactor.listeners.ReactorExistsListener;
import com.aerospike.client.reactor.listeners.ReactorExistsSequenceListener;
import com.aerospike.client.reactor.listeners.ReactorRecordArrayListener;
import com.aerospike.client.reactor.listeners.ReactorRecordListener;
import com.aerospike.client.reactor.listeners.ReactorRecordSequenceListener;
import com.aerospike.client.reactor.listeners.ReactorWriteListener;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class AerospikeReactorClient
implements IAerospikeReactorClient {
    private final IAerospikeClient aerospikeClient;
    private final EventLoops eventLoops;

    public AerospikeReactorClient(IAerospikeClient aerospikeClient, EventLoops eventLoops) {
        this.aerospikeClient = aerospikeClient;
        this.eventLoops = eventLoops;
    }

    @Override
    public void close() {
        this.aerospikeClient.close();
    }

    @Override
    public final Mono<KeyRecord> get(Key key) throws AerospikeException {
        return this.get(null, key);
    }

    @Override
    public final Mono<KeyRecord> get(Policy policy, Key key) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.get(this.eventLoops.next(), (RecordListener)new ReactorRecordListener((MonoSink<KeyRecord>)sink), policy, key));
    }

    @Override
    public final Mono<KeysRecords> get(Key[] keys) throws AerospikeException {
        return this.get(null, keys);
    }

    @Override
    public final Mono<KeysRecords> get(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.get(this.eventLoops.next(), (RecordArrayListener)new ReactorRecordArrayListener((MonoSink<KeysRecords>)sink), policy, keys));
    }

    @Override
    public final Mono<List<BatchRead>> get(List<BatchRead> records) throws AerospikeException {
        return this.get(null, records);
    }

    @Override
    public final Mono<List<BatchRead>> get(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.get(this.eventLoops.next(), (BatchListListener)new ReactorBatchListListener((MonoSink<List<BatchRead>>)sink), policy, records));
    }

    @Override
    public final Flux<BatchRead> getFlux(List<BatchRead> records) throws AerospikeException {
        return this.getFlux(null, records);
    }

    @Override
    public final Flux<BatchRead> getFlux(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        return Flux.create(sink -> this.aerospikeClient.get(this.eventLoops.next(), (BatchSequenceListener)new ReactorBatchSequenceListener((FluxSink<BatchRead>)sink), policy, records));
    }

    @Override
    public final Flux<KeyRecord> getFlux(Key[] keys) throws AerospikeException {
        return this.getFlux(null, keys);
    }

    @Override
    public final Flux<KeyRecord> getFlux(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return Flux.create(sink -> this.aerospikeClient.get(this.eventLoops.next(), (RecordSequenceListener)new ReactorRecordSequenceListener((FluxSink<KeyRecord>)sink), policy, keys));
    }

    @Override
    public final Mono<KeyRecord> getHeader(Key key) throws AerospikeException {
        return this.getHeader(null, key);
    }

    @Override
    public final Mono<KeyRecord> getHeader(Policy policy, Key key) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.getHeader(this.eventLoops.next(), (RecordListener)new ReactorRecordListener((MonoSink<KeyRecord>)sink), policy, key));
    }

    @Override
    public final Mono<KeysRecords> getHeaders(Key[] keys) throws AerospikeException {
        return this.getHeaders(null, keys);
    }

    @Override
    public final Mono<KeysRecords> getHeaders(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.getHeader(this.eventLoops.next(), (RecordArrayListener)new ReactorRecordArrayListener((MonoSink<KeysRecords>)sink), policy, keys));
    }

    @Override
    public final Mono<Key> touch(Key key) throws AerospikeException {
        return this.touch(null, key);
    }

    @Override
    public final Mono<Key> touch(WritePolicy policy, Key key) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.touch(this.eventLoops.next(), (WriteListener)new ReactorWriteListener((MonoSink<Key>)sink), policy, key));
    }

    @Override
    public final Mono<Key> exists(Key key) throws AerospikeException {
        return this.exists(null, key);
    }

    @Override
    public final Mono<Key> exists(Policy policy, Key key) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.exists(this.eventLoops.next(), (ExistsListener)new ReactorExistsListener((MonoSink<Key>)sink), policy, key));
    }

    @Override
    public final Mono<KeysExists> exists(Key[] keys) throws AerospikeException {
        return this.exists(null, keys);
    }

    @Override
    public final Mono<KeysExists> exists(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.exists(this.eventLoops.next(), (ExistsArrayListener)new ReactorExistsArrayListener((MonoSink<KeysExists>)sink), policy, keys));
    }

    @Override
    public final Flux<KeyExists> existsFlux(Key[] keys) throws AerospikeException {
        return this.existsFlux(null, keys);
    }

    @Override
    public final Flux<KeyExists> existsFlux(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return Flux.create(sink -> this.aerospikeClient.exists(this.eventLoops.next(), (ExistsSequenceListener)new ReactorExistsSequenceListener((FluxSink<KeyExists>)sink), policy, keys));
    }

    @Override
    public final Mono<Key> put(Key key, Bin ... bins) throws AerospikeException {
        return this.put(null, key, bins);
    }

    @Override
    public final Mono<Key> put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.put(this.eventLoops.next(), (WriteListener)new ReactorWriteListener((MonoSink<Key>)sink), policy, key, bins));
    }

    @Override
    public final Mono<Key> append(Key key, Bin ... bins) throws AerospikeException {
        return this.append(null, key, bins);
    }

    @Override
    public final Mono<Key> append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.append(this.eventLoops.next(), (WriteListener)new ReactorWriteListener((MonoSink<Key>)sink), policy, key, bins));
    }

    @Override
    public final Mono<Key> prepend(Key key, Bin ... bins) throws AerospikeException {
        return this.prepend(null, key, bins);
    }

    @Override
    public final Mono<Key> prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.prepend(this.eventLoops.next(), (WriteListener)new ReactorWriteListener((MonoSink<Key>)sink), policy, key, bins));
    }

    @Override
    public final Mono<Key> add(Key key, Bin ... bins) throws AerospikeException {
        return this.add(null, key, bins);
    }

    @Override
    public final Mono<Key> add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.add(this.eventLoops.next(), (WriteListener)new ReactorWriteListener((MonoSink<Key>)sink), policy, key, bins));
    }

    @Override
    public final Mono<Key> delete(Key key) throws AerospikeException {
        return this.delete(null, key);
    }

    @Override
    public final Mono<Key> delete(WritePolicy policy, Key key) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.delete(this.eventLoops.next(), (DeleteListener)new ReactorDeleteListener((MonoSink<Key>)sink), policy, key));
    }

    @Override
    public final Mono<KeyRecord> operate(Key key, Operation ... operations) throws AerospikeException {
        return this.operate(null, key, operations);
    }

    @Override
    public final Mono<KeyRecord> operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.operate(this.eventLoops.next(), (RecordListener)new ReactorRecordListener((MonoSink<KeyRecord>)sink), policy, key, operations));
    }

    @Override
    public final Flux<KeyRecord> query(Statement statement) throws AerospikeException {
        return this.query(null, statement);
    }

    @Override
    public final Flux<KeyRecord> query(QueryPolicy policy, Statement statement) throws AerospikeException {
        return Flux.create(sink -> this.aerospikeClient.query(this.eventLoops.next(), (RecordSequenceListener)new ReactorRecordSequenceListener((FluxSink<KeyRecord>)sink), policy, statement));
    }

    @Override
    public final Flux<KeyRecord> scanAll(String namespace, String setName, String ... binNames) throws AerospikeException {
        return this.scanAll((ScanPolicy)null, namespace, setName, binNames);
    }

    @Override
    public final Flux<KeyRecord> scanAll(ScanPolicy policy, String namespace, String setName, String ... binNames) throws AerospikeException {
        return Flux.create(sink -> this.aerospikeClient.scanAll(this.eventLoops.next(), (RecordSequenceListener)new ReactorRecordSequenceListener((FluxSink<KeyRecord>)sink), policy, namespace, setName, binNames));
    }

    @Override
    public final Mono<KeyObject> execute(Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        return this.execute(null, key, packageName, functionName, functionArgs);
    }

    @Override
    public final Mono<KeyObject> execute(WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        return Mono.create(sink -> this.aerospikeClient.execute(this.eventLoops.next(), (ExecuteListener)new ReactorExecuteListener((MonoSink<KeyObject>)sink), policy, key, packageName, functionName, functionArgs));
    }
}

