/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.reactor.retry;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.client.reactor.dto.KeyExists;
import com.aerospike.client.reactor.dto.KeyObject;
import com.aerospike.client.reactor.dto.KeysExists;
import com.aerospike.client.reactor.dto.KeysRecords;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class AerospikeReactorRetryClient
implements IAerospikeReactorClient {
    private final IAerospikeReactorClient client;
    private final Retry retryPolicy;

    public AerospikeReactorRetryClient(IAerospikeReactorClient client, Retry retryPolicy) {
        this.client = client;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public final Mono<KeyRecord> get(Key key) throws AerospikeException {
        return this.get(null, key);
    }

    @Override
    public final Mono<KeyRecord> get(Policy policy, Key key) throws AerospikeException {
        return this.client.get(policy, key).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeyRecord> get(Policy policy, Key key, String[] binNames) throws AerospikeException {
        return this.client.get(policy, key, binNames).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeysRecords> get(Key[] keys) throws AerospikeException {
        return this.get(null, keys);
    }

    @Override
    public final Mono<KeysRecords> get(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return this.client.get(policy, keys).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<List<BatchRead>> get(List<BatchRead> records) throws AerospikeException {
        return this.get(null, records);
    }

    @Override
    public final Mono<List<BatchRead>> get(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        return this.client.get(policy, records).retryWhen(this.retryPolicy);
    }

    @Override
    public final Flux<BatchRead> getFlux(List<BatchRead> records) throws AerospikeException {
        return this.getFlux(null, records);
    }

    @Override
    public final Flux<BatchRead> getFlux(BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        return this.client.getFlux(policy, records).retryWhen(this.retryPolicy);
    }

    @Override
    public final Flux<KeyRecord> getFlux(Key[] keys) throws AerospikeException {
        return this.getFlux(null, keys);
    }

    @Override
    public final Flux<KeyRecord> getFlux(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return this.client.getFlux(policy, keys).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeyRecord> getHeader(Key key) throws AerospikeException {
        return this.getHeader(null, key);
    }

    @Override
    public final Mono<KeyRecord> getHeader(Policy policy, Key key) throws AerospikeException {
        return this.client.getHeader(policy, key).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeysRecords> getHeaders(Key[] keys) throws AerospikeException {
        return this.getHeaders(null, keys);
    }

    @Override
    public final Mono<KeysRecords> getHeaders(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return this.client.getHeaders(policy, keys).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> touch(Key key) throws AerospikeException {
        return this.touch(null, key);
    }

    @Override
    public final Mono<Key> touch(WritePolicy policy, Key key) throws AerospikeException {
        return this.client.touch(policy, key).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> exists(Key key) throws AerospikeException {
        return this.exists(null, key);
    }

    @Override
    public final Mono<Key> exists(Policy policy, Key key) throws AerospikeException {
        return this.client.exists(policy, key).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeysExists> exists(Key[] keys) throws AerospikeException {
        return this.exists(null, keys);
    }

    @Override
    public final Mono<KeysExists> exists(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return this.client.exists(policy, keys).retryWhen(this.retryPolicy);
    }

    @Override
    public final Flux<KeyExists> existsFlux(Key[] keys) throws AerospikeException {
        return this.existsFlux(null, keys);
    }

    @Override
    public final Flux<KeyExists> existsFlux(BatchPolicy policy, Key[] keys) throws AerospikeException {
        return this.client.existsFlux(policy, keys).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> put(Key key, Bin ... bins) throws AerospikeException {
        return this.put(null, key, bins);
    }

    @Override
    public final Mono<Key> put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return this.client.put(policy, key, bins).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> append(Key key, Bin ... bins) throws AerospikeException {
        return this.append(null, key, bins);
    }

    @Override
    public final Mono<Key> append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return this.client.append(policy, key, bins).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> prepend(Key key, Bin ... bins) throws AerospikeException {
        return this.prepend(null, key, bins);
    }

    @Override
    public final Mono<Key> prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return this.client.prepend(policy, key, bins).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> add(Key key, Bin ... bins) throws AerospikeException {
        return this.add(null, key, bins);
    }

    @Override
    public final Mono<Key> add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        return this.client.add(policy, key, bins).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<Key> delete(Key key) throws AerospikeException {
        return this.delete(null, key);
    }

    @Override
    public final Mono<Key> delete(WritePolicy policy, Key key) throws AerospikeException {
        return this.client.delete(policy, key).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeyRecord> operate(Key key, Operation ... operations) throws AerospikeException {
        return this.operate(null, key, operations);
    }

    @Override
    public final Mono<KeyRecord> operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        return this.client.operate(policy, key, operations).retryWhen(this.retryPolicy);
    }

    @Override
    public final Flux<KeyRecord> query(Statement statement) throws AerospikeException {
        return this.query(null, statement);
    }

    @Override
    public final Flux<KeyRecord> query(QueryPolicy policy, Statement statement) throws AerospikeException {
        return this.client.query(policy, statement).retryWhen(this.retryPolicy);
    }

    @Override
    public final Flux<KeyRecord> scanAll(String namespace, String setName, String ... binNames) throws AerospikeException {
        return this.scanAll((ScanPolicy)null, namespace, setName, binNames);
    }

    @Override
    public final Flux<KeyRecord> scanAll(ScanPolicy policy, String namespace, String setName, String ... binNames) throws AerospikeException {
        return this.client.scanAll(policy, namespace, setName, binNames).retryWhen(this.retryPolicy);
    }

    @Override
    public final Mono<KeyObject> execute(Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        return this.execute(null, key, packageName, functionName, functionArgs);
    }

    @Override
    public final Mono<KeyObject> execute(WritePolicy policy, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        return this.client.execute(policy, key, packageName, functionName, functionArgs).retryWhen(this.retryPolicy);
    }

    @Override
    public Mono<String> info(InfoPolicy infoPolicy, Node node, String command) {
        return this.client.info(infoPolicy, node, command).retryWhen(this.retryPolicy);
    }

    @Override
    public Mono<Map<String, String>> info(InfoPolicy infoPolicy, Node node, List<String> commands) {
        return this.client.info(infoPolicy, node, commands).retryWhen(this.retryPolicy);
    }

    @Override
    public Mono<Void> createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.client.createIndex(policy, namespace, setName, indexName, binName, indexType, indexCollectionType).retryWhen(this.retryPolicy);
    }

    @Override
    public Mono<Void> dropIndex(Policy policy, String namespace, String setName, String indexName) {
        return this.client.dropIndex(policy, namespace, setName, indexName).retryWhen(this.retryPolicy);
    }

    @Override
    public Policy getReadPolicyDefault() {
        return this.client.getReadPolicyDefault();
    }

    @Override
    public WritePolicy getWritePolicyDefault() {
        return this.client.getWritePolicyDefault();
    }

    @Override
    public ScanPolicy getScanPolicyDefault() {
        return this.client.getScanPolicyDefault();
    }

    @Override
    public QueryPolicy getQueryPolicyDefault() {
        return this.client.getQueryPolicyDefault();
    }

    @Override
    public BatchPolicy getBatchPolicyDefault() {
        return this.client.getBatchPolicyDefault();
    }

    @Override
    public InfoPolicy getInfoPolicyDefault() {
        return this.client.getInfoPolicyDefault();
    }
}

