/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.reactor.retry;

import com.aerospike.client.AerospikeException;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

public final class RetryFactories {
    private static final Random random = new Random();

    private RetryFactories() {
    }

    public static Retry retryOnNoMoreConnections() {
        return RetryFactories.retryOn(throwable -> throwable instanceof AerospikeException.Connection && ((AerospikeException.Connection)throwable).getResultCode() == -7);
    }

    public static Retry retryOn(Predicate<Throwable> retryOn) {
        AtomicLong backOff = new AtomicLong();
        return RetryFactories.retry((throwable, integer) -> retryOn.test((Throwable)throwable) ? backOff.addAndGet(random.nextInt(10)) : -1L);
    }

    public static Retry retry(final BiFunction<Throwable, Integer, Long> retryDelay) {
        return new Retry(){

            public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> throwableFlux) {
                return throwableFlux.map(Retry.RetrySignal::failure).zipWith((Publisher)Flux.range((int)1, (int)Integer.MAX_VALUE), (error, index) -> {
                    long delay = (Long)retryDelay.apply(error, index);
                    if (delay >= 0L) {
                        return Tuples.of((Object)delay, (Object)error);
                    }
                    throw Exceptions.propagate((Throwable)error);
                }).concatMap(tuple2 -> (Long)tuple2.getT1() > 0L ? Mono.delay((Duration)Duration.ofMillis((Long)tuple2.getT1())).map(time -> (Throwable)tuple2.getT2()) : Mono.just((Object)((Throwable)tuple2.getT2())));
            }
        };
    }
}

