/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.helper.query;

import com.aerospike.client.Key;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.helper.query.KeyQualifier;
import com.aerospike.helper.query.Qualifier;
import com.aerospike.helper.query.QueryEngine;
import com.aerospike.helper.query.cache.IndexInfoParser;
import com.aerospike.helper.query.cache.InternalIndexOperations;
import com.aerospike.helper.query.cache.ReactorIndexCache;
import java.io.Closeable;
import java.io.IOException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQueryEngine
implements Closeable {
    private final IAerospikeReactorClient client;
    private final QueryPolicy queryPolicy;
    private final ReactorIndexCache indexCache;

    public ReactorQueryEngine(IAerospikeReactorClient client) {
        this(client, client.getQueryPolicyDefault(), new ReactorIndexCache(client, client.getInfoPolicyDefault(), new InternalIndexOperations(new IndexInfoParser())));
    }

    public ReactorQueryEngine(IAerospikeReactorClient client, QueryPolicy queryPolicy, ReactorIndexCache indexCache) {
        this.client = client;
        this.queryPolicy = queryPolicy;
        this.indexCache = indexCache;
    }

    public Flux<KeyRecord> select(String namespace, String set, Filter filter, Qualifier ... qualifiers) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (filter != null) {
            stmt.setFilter(filter);
        }
        return this.select(stmt, qualifiers);
    }

    public Flux<KeyRecord> select(Statement stmt, Qualifier ... qualifiers) {
        return this.select(stmt, false, qualifiers);
    }

    public Flux<KeyRecord> select(Statement stmt, boolean metaOnly, Qualifier ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            return this.client.query(this.queryPolicy, stmt);
        }
        if (qualifiers.length == 1 && qualifiers[0] instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifiers[0];
            Key key = kq.makeKey(stmt.getNamespace(), stmt.getSetName());
            if (metaOnly) {
                return Flux.from((Publisher)this.client.getHeader(null, key));
            }
            return Flux.from((Publisher)this.client.get(null, key, stmt.getBinNames()));
        }
        QueryEngine.updateStatement((Statement)stmt, (Qualifier[])qualifiers, this.indexCache::hasIndexFor);
        return this.client.query(this.queryPolicy, stmt);
    }

    public Mono<Void> refreshIndexes() {
        return this.indexCache.refreshIndexes();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        this.indexCache.close();
    }
}

