/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.helper.query.cache;

import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.helper.model.Index;
import com.aerospike.helper.query.cache.IndexKey;
import com.aerospike.helper.query.cache.IndexedField;
import com.aerospike.helper.query.cache.InternalIndexOperations;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReactorIndexCache
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ReactorIndexCache.class);
    private volatile InternalIndexOperations.Cache cache = InternalIndexOperations.Cache.empty();
    private final IAerospikeReactorClient client;
    private final InfoPolicy infoPolicy;
    private final InternalIndexOperations indexOperations;

    public ReactorIndexCache(IAerospikeReactorClient client, InfoPolicy infoPolicy, InternalIndexOperations indexOperations) {
        this.client = client;
        this.infoPolicy = infoPolicy;
        this.indexOperations = indexOperations;
    }

    public Optional<Index> getIndex(IndexKey indexKey) {
        return Optional.ofNullable(this.cache.indexes.get(indexKey));
    }

    public boolean hasIndexFor(IndexedField indexedField) {
        return this.cache.indexedFields.contains(indexedField);
    }

    public Mono<Void> refreshIndexes() {
        return this.client.info(this.infoPolicy, null, this.indexOperations.buildGetIndexesCommand()).doOnSubscribe(subscription -> log.trace("Loading indexes")).doOnNext(indexInfo -> {
            this.cache = this.indexOperations.parseIndexesInfo(indexInfo);
            log.debug("Loaded indexes: {}", (Object)this.cache.indexes);
        }).then();
    }

    @Override
    public void close() {
        this.cache = InternalIndexOperations.Cache.empty();
    }
}

