/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.shiro;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Priority;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.shiro.ShiroException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeSessionDAO
extends CachingSessionDAO
implements Destroyable,
Initializable {
    private static final Map<String, String> PROPERTY_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("AEROSPIKE_SESSION_NAMESPACE", "setNamespace");
            this.put("AEROSPIKE_SESSION_SETNAME", "setSetname");
            this.put("AEROSPIKE_SESSION_BINNAME", "setBinname");
            this.put("AEROSPIKE_SESSION_HOSTNAME", "setHostname");
            this.put("AEROSPIKE_SESSION_PORT", "setPort");
            this.put("AEROSPIKE_SESSION_GLOBAL_TIMEOUT", "setGlobalSessionTimeout");
            this.put("AEROSPIKE_SESSION_USER", "setUser");
            this.put("AEROSPIKE_SESSION_PASSWORD", "setPassword");
        }
    });
    private String namespace = "test";
    private String setname = "sessions";
    private String binname = "data";
    private String hostname = "localhost";
    private String user = null;
    private String password = null;
    private String port = "3000";
    private int globalSessionTimeout = 1800;
    private AerospikeClient client;
    private WritePolicy writePolicy;
    private static final transient Logger log = LoggerFactory.getLogger(AerospikeSessionDAO.class);

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSetname(String setname) {
        this.setname = setname;
    }

    public void setBinname(String binname) {
        this.binname = binname;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setGlobalSessionTimeout(long timeout) {
        this.globalSessionTimeout = (int)(timeout / 1000L);
        log.info("Aerospike DAO session timeout: " + this.globalSessionTimeout + " seconds.");
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(String port) {
        this.port = port;
    }

    private void setGlobalSessionTimeout(String timeout) {
        this.setGlobalSessionTimeout(Long.valueOf(timeout));
    }

    public void init() throws ShiroException {
        log.info("Initializing the Aerospike Client");
        try {
            this.readEnvironmentVariables();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(e.getMessage());
            throw new ShiroException(e.getMessage());
        }
        ClientPolicy policy = new ClientPolicy();
        policy.failIfNotConnected = true;
        policy.user = this.user;
        policy.password = this.password;
        String[] hostnames = StringUtils.split((String)this.hostname);
        String[] ports = StringUtils.split((String)this.port);
        if (hostnames.length != ports.length) {
            throw new ShiroException("Number of hosts in configuration does not match number of ports");
        }
        Host[] hosts = new Host[hostnames.length];
        for (int i = 0; i < hostnames.length; ++i) {
            hosts[i] = new Host(hostnames[i], Integer.valueOf(ports[i]).intValue());
        }
        this.client = new AerospikeClient(policy, hosts);
        this.writePolicy = new WritePolicy();
        this.writePolicy.expiration = this.globalSessionTimeout;
    }

    public void destroy() throws Exception {
        log.info("Destroying the Aerospike Client");
        this.client.close();
    }

    public Serializable doCreate(Session session) {
        String id = UUID.randomUUID().toString();
        log.info("Creating session " + id);
        this.assignSessionId(session, (Serializable)((Object)id));
        this.storeSession(id, session);
        return id;
    }

    public void doDelete(Session session) {
        log.info("Deleting session " + session.getId());
        Key key = new Key(this.namespace, this.setname, (String)((Object)session.getId()));
        this.client.delete(null, key);
    }

    public Session doReadSession(Serializable sessionId) throws UnknownSessionException {
        Session session = null;
        Key key = new Key(this.namespace, this.setname, (String)((Object)sessionId));
        Record rec = this.client.get(null, key);
        if (rec == null) {
            throw new UnknownSessionException();
        }
        session = (Session)rec.getValue(this.binname);
        this.client.touch(this.writePolicy, key);
        return session;
    }

    public void doUpdate(Session session) throws UnknownSessionException {
        Key key = new Key(this.namespace, this.setname, (String)((Object)session.getId()));
        Record rec = this.client.get(null, key);
        if (rec == null) {
            throw new UnknownSessionException();
        }
        this.storeSession((String)((Object)session.getId()), session);
    }

    public Collection<Session> getActiveSessions() {
        log.info("Getting all active sessions");
        HashSet<Session> sessions = new HashSet<Session>();
        try {
            ScanPolicy policy = new ScanPolicy();
            policy.concurrentNodes = true;
            policy.priority = Priority.LOW;
            policy.includeBinData = true;
            class SessionScanner
            implements ScanCallback {
                private String binname;
                private Set<Session> sessions;

                public SessionScanner(String binname, Set<Session> sessions) {
                    this.binname = binname;
                    this.sessions = sessions;
                }

                public void scanCallback(Key key, Record record) throws AerospikeException {
                    this.sessions.add((Session)record.getValue(this.binname));
                }
            }
            this.client.scanAll(policy, this.namespace, this.setname, (ScanCallback)new SessionScanner(this.binname, sessions), new String[]{this.binname});
        }
        catch (AerospikeException e) {
            log.error(e.getMessage());
        }
        return sessions;
    }

    private void storeSession(String id, Session session) {
        Key key = new Key(this.namespace, this.setname, id);
        Bin bin = new Bin(this.binname, (Object)session);
        this.client.put(this.writePolicy, key, new Bin[]{bin});
    }

    private void readEnvironmentVariables() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class[] paramString = new Class[]{String.class};
        for (String key : PROPERTY_MAP.keySet()) {
            if (System.getProperty(key) == null) continue;
            Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(PROPERTY_MAP.get(key), paramString);
            method.invoke((Object)this, System.getProperty(key));
        }
    }
}

