/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.mapper.exceptions.NotAnnotatedClass;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.configuration.ClassConfig;
import com.aerospike.mapper.tools.configuration.Configuration;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class ClassCache {
    private static final ClassCache instance = new ClassCache();
    private final Map<Class<?>, ClassCacheEntry<?>> cacheMap = new HashMap();
    private final Map<String, ClassConfig> classesConfig = new HashMap<String, ClassConfig>();
    private final Map<PolicyType, Policy> defaultPolicies = new HashMap<PolicyType, Policy>();
    private final Map<String, ClassCacheEntry<?>> storedNameToCacheEntry = new HashMap();
    private final Map<PolicyType, Map<Class<?>, Policy>> childrenPolicies = new HashMap();
    private final Map<PolicyType, Map<Class<?>, Policy>> specificPolicies = new HashMap();
    private final Object lock = new Object();

    private ClassCache() {
        for (PolicyType thisType : PolicyType.values()) {
            this.childrenPolicies.put(thisType, new HashMap());
            this.specificPolicies.put(thisType, new HashMap());
        }
    }

    public static ClassCache getInstance() {
        return instance;
    }

    public <T> ClassCacheEntry<T> loadClass(@NotNull Class<T> clazz, IBaseAeroMapper mapper) {
        return this.loadClass(clazz, mapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ClassCacheEntry<T> loadClass(@NotNull Class<T> clazz, IBaseAeroMapper mapper, boolean requireRecord) {
        if (clazz.isPrimitive() || clazz.equals(Object.class) || clazz.equals(String.class) || clazz.equals(Character.class) || Number.class.isAssignableFrom(clazz)) {
            return null;
        }
        ClassCacheEntry<Object> entry = this.cacheMap.get(clazz);
        if (entry == null || entry.isNotConstructed()) {
            Object object = this.lock;
            synchronized (object) {
                entry = this.cacheMap.get(clazz);
                if (entry == null) {
                    try {
                        entry = new ClassCacheEntry<T>(clazz, mapper, this.getClassConfig(clazz), requireRecord, this.determinePolicy(clazz, PolicyType.READ), (WritePolicy)this.determinePolicy(clazz, PolicyType.WRITE), (BatchPolicy)this.determinePolicy(clazz, PolicyType.BATCH), (QueryPolicy)this.determinePolicy(clazz, PolicyType.QUERY), (ScanPolicy)this.determinePolicy(clazz, PolicyType.SCAN));
                    }
                    catch (NotAnnotatedClass nae) {
                        return null;
                    }
                    this.cacheMap.put(clazz, entry);
                    try {
                        entry.construct();
                    }
                    catch (IllegalArgumentException iae) {
                        this.cacheMap.remove(clazz);
                        return null;
                    }
                    catch (Exception e) {
                        this.cacheMap.remove(clazz);
                        throw e;
                    }
                }
            }
        }
        return entry;
    }

    void setStoredName(@NotNull ClassCacheEntry<?> entry, @NotNull String name) {
        ClassCacheEntry<?> existingEntry = this.storedNameToCacheEntry.get(name);
        if (existingEntry != null && !existingEntry.equals(entry)) {
            String errorMessage = String.format("Stored name of \"%s\" is used for both %s and %s", name, existingEntry.getUnderlyingClass().getName(), entry.getUnderlyingClass().getName());
            throw new AerospikeException(errorMessage);
        }
        this.storedNameToCacheEntry.put(name, entry);
    }

    public ClassCacheEntry<?> getCacheEntryFromStoredName(@NotNull String name) {
        return this.storedNameToCacheEntry.get(name);
    }

    void setDefaultPolicies(IAerospikeClient client) {
        if (client != null) {
            this.defaultPolicies.put(PolicyType.READ, client.getReadPolicyDefault());
            this.defaultPolicies.put(PolicyType.WRITE, (Policy)client.getWritePolicyDefault());
            this.defaultPolicies.put(PolicyType.BATCH, (Policy)client.getBatchPolicyDefault());
            this.defaultPolicies.put(PolicyType.QUERY, (Policy)client.getQueryPolicyDefault());
            this.defaultPolicies.put(PolicyType.SCAN, (Policy)client.getScanPolicyDefault());
        }
    }

    void setReactiveDefaultPolicies(IAerospikeReactorClient reactorClient) {
        this.defaultPolicies.put(PolicyType.READ, reactorClient.getReadPolicyDefault());
        this.defaultPolicies.put(PolicyType.WRITE, (Policy)reactorClient.getWritePolicyDefault());
        this.defaultPolicies.put(PolicyType.BATCH, (Policy)reactorClient.getBatchPolicyDefault());
        this.defaultPolicies.put(PolicyType.QUERY, (Policy)reactorClient.getQueryPolicyDefault());
        this.defaultPolicies.put(PolicyType.SCAN, (Policy)reactorClient.getScanPolicyDefault());
    }

    void setDefaultPolicy(PolicyType policyType, Policy policy) {
        this.defaultPolicies.put(policyType, policy);
    }

    void setChildrenPolicy(PolicyType policyType, Class<?> parentClass, Policy policy) {
        this.childrenPolicies.get((Object)policyType).put(parentClass, policy);
    }

    void setSpecificPolicy(PolicyType policyType, Class<?> parentClass, Policy policy) {
        this.childrenPolicies.get((Object)policyType).put(parentClass, policy);
    }

    public boolean hasClass(Class<?> clazz) {
        return this.cacheMap.containsKey(clazz);
    }

    private Policy determinePolicy(@NotNull Class<?> clazz, @NotNull PolicyType policyType) {
        Policy result = this.specificPolicies.get((Object)policyType).get(clazz);
        if (result != null) {
            return result;
        }
        for (Class<?> thisClass = clazz; thisClass != null; thisClass = thisClass.getSuperclass()) {
            Policy aPolicy = this.childrenPolicies.get((Object)policyType).get(thisClass);
            if (aPolicy == null) continue;
            return aPolicy;
        }
        return this.defaultPolicies.get((Object)policyType);
    }

    public void clear() {
        this.cacheMap.clear();
        this.classesConfig.clear();
        TypeUtils.clear();
        this.storedNameToCacheEntry.clear();
    }

    public void addConfiguration(@NotNull Configuration configuration) {
        for (ClassConfig thisConfig : configuration.getClasses()) {
            this.classesConfig.put(thisConfig.getClassName(), thisConfig);
        }
    }

    public ClassConfig getClassConfig(String className) {
        return this.classesConfig.get(className);
    }

    public ClassConfig getClassConfig(Class<?> clazz) {
        return this.classesConfig.get(clazz.getName());
    }

    public boolean hasClassConfig(String className) {
        return this.classesConfig.containsKey(className);
    }

    public boolean hasClassConfig(Class<?> clazz) {
        return this.classesConfig.containsKey(clazz.getName());
    }

    static enum PolicyType {
        READ,
        WRITE,
        BATCH,
        SCAN,
        QUERY;

    }
}

