/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.configuration.ClassConfig;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

public class PropertyDefinition {
    private final String name;
    private final IBaseAeroMapper mapper;
    private Method getter;
    private Method setter;
    private Class<?> clazz;
    private TypeMapper typeMapper;
    private SetterParamType setterParamType = SetterParamType.NONE;

    public PropertyDefinition(String name, IBaseAeroMapper mapper) {
        this.name = name;
        this.mapper = mapper;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public SetterParamType getSetterParamType() {
        return this.setterParamType;
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public Annotation[] getAnnotations() {
        return this.getter != null ? this.getter.getAnnotations() : this.setter.getAnnotations();
    }

    public Type getGenericType() {
        return this.getter.getGenericReturnType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(String className, ClassConfig config, boolean allowNoSetter) {
        if (this.getter == null) {
            throw new AerospikeException(String.format("Property %s on class %s must have a getter", this.name, className));
        }
        if (this.getter.getParameterCount() != 0) {
            throw new AerospikeException(String.format("Getter for property %s on class %s must take 0 arguments", this.name, className));
        }
        Class<?> getterClazz = this.getter.getReturnType();
        if (TypeUtils.isVoidType(getterClazz)) {
            throw new AerospikeException(String.format("Getter for property %s on class %s cannot return void", this.name, className));
        }
        this.getter.setAccessible(true);
        Class<?> setterClazz = null;
        if (this.setter != null || !allowNoSetter) {
            if (this.setter == null) {
                throw new AerospikeException(String.format("Property %s on class %s must have a setter", this.name, className));
            }
            if (this.setter.getParameterCount() == 2) {
                Parameter param = this.setter.getParameters()[1];
                if (param.getType().isAssignableFrom(Key.class)) {
                    this.setterParamType = SetterParamType.KEY;
                } else {
                    if (!param.getType().isAssignableFrom(Value.class)) throw new AerospikeException(String.format("Property %s on class %s has a setter with 2 arguments, but the second one is neither a Key nor a Value", this.name, className));
                    this.setterParamType = SetterParamType.VALUE;
                }
            } else if (this.setter.getParameterCount() != 1) {
                throw new AerospikeException(String.format("Setter for property %s on class %s must take 1 or 2 arguments", this.name, className));
            }
            setterClazz = this.setter.getParameterTypes()[0];
            this.setter.setAccessible(true);
        }
        if (setterClazz != null && !getterClazz.equals(setterClazz)) {
            throw new AerospikeException(String.format("Getter (%s) and setter (%s) for property %s on class %s differ in type", getterClazz.getName(), setterClazz.getName(), this.name, className));
        }
        this.clazz = getterClazz;
        this.typeMapper = TypeUtils.getMapper(this.clazz, new TypeUtils.AnnotatedType(config, this.getter), this.mapper);
    }

    public static enum SetterParamType {
        NONE,
        KEY,
        VALUE;

    }
}

