/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.mapper.annotations.AerospikeVersion;
import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.PropertyDefinition;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.validation.constraints.NotNull;

public abstract class ValueType {
    private int minimumVersion = 1;
    private int maximumVersion = Integer.MAX_VALUE;
    private final TypeMapper mapper;
    private final TypeUtils.AnnotatedType annotatedType;

    public ValueType(@NotNull TypeMapper mapper, TypeUtils.AnnotatedType annotatedType) {
        this.mapper = mapper;
        this.annotatedType = annotatedType;
    }

    public abstract Object get(Object var1) throws ReflectiveOperationException;

    public abstract void set(Object var1, Object var2) throws ReflectiveOperationException;

    public abstract Class<?> getType();

    public abstract Annotation[] getAnnotations();

    public int getMinimumVersion() {
        return this.minimumVersion;
    }

    public int getMaximumVersion() {
        return this.maximumVersion;
    }

    protected void setVersion(AerospikeVersion version) {
        if (version.min() <= 0) {
            throw new AerospikeException("Minimum version must be greater than or equal to 1, not " + version.min());
        }
        if (version.max() <= 0) {
            throw new AerospikeException("Maximum version must be greater than or equal to 1, not " + version.max());
        }
        if (version.min() > version.max()) {
            throw new AerospikeException("Maximum version must be greater than or equal to the minumum version, not " + version.max());
        }
        this.maximumVersion = version.max();
        this.minimumVersion = version.min();
    }

    public TypeMapper getTypeMapper() {
        return this.mapper;
    }

    public TypeUtils.AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    public static class MethodValue
    extends ValueType {
        private final PropertyDefinition property;

        public MethodValue(PropertyDefinition property, TypeMapper typeMapper, TypeUtils.AnnotatedType annotatedType) {
            super(typeMapper, annotatedType);
            this.property = property;
        }

        @Override
        public Object get(Object obj) throws ReflectiveOperationException {
            if (obj == null) {
                return null;
            }
            return this.property.getGetter().invoke(obj, new Object[0]);
        }

        @Override
        public void set(Object obj, Object value) throws ReflectiveOperationException {
            if (this.property.getSetter() == null) {
                throw new AerospikeException("Lazy loading cannot be used on objects with a property key type and no annotated key setter method");
            }
            switch (this.property.getSetterParamType()) {
                case KEY: {
                    Key key = ThreadLocalKeySaver.get();
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value, key);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new AerospikeException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value, key);
                    break;
                }
                case VALUE: {
                    Key key = ThreadLocalKeySaver.get();
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value, key.userKey);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new AerospikeException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value, key.userKey);
                    break;
                }
                default: {
                    if (value instanceof DeferredObjectLoader.DeferredObject) {
                        DeferredObjectLoader.DeferredSetter setter = object -> {
                            try {
                                this.property.getSetter().invoke(obj, value);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new AerospikeException(String.format("Could not set field %s on %s to %s", this.property, obj, value));
                            }
                        };
                        DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                        DeferredObjectLoader.add(objectSetter);
                        break;
                    }
                    this.property.getSetter().invoke(obj, value);
                }
            }
        }

        @Override
        public Class<?> getType() {
            return this.property.getType();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.property.getAnnotations();
        }

        public String toString() {
            return String.format("Value(Method): %s/%s (%s)", this.property.getGetter(), this.property.getSetter(), this.property.getType().getSimpleName());
        }
    }

    public static class FieldValue
    extends ValueType {
        private final Field field;

        public FieldValue(Field field, TypeMapper typeMapper, TypeUtils.AnnotatedType annotatedType) {
            super(typeMapper, annotatedType);
            this.field = field;
            this.field.setAccessible(true);
            if (this.field.isAnnotationPresent(AerospikeVersion.class)) {
                AerospikeVersion version = this.field.getAnnotation(AerospikeVersion.class);
                super.setVersion(version);
            }
        }

        @Override
        public Object get(Object obj) throws ReflectiveOperationException {
            return this.field.get(obj);
        }

        @Override
        public void set(Object obj, Object value) throws ReflectiveOperationException {
            if (value instanceof DeferredObjectLoader.DeferredObject) {
                DeferredObjectLoader.DeferredSetter setter = object -> {
                    try {
                        this.field.set(obj, object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new AerospikeException(String.format("Could not set field %s on %s to %s", this.field, obj, value));
                    }
                };
                DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)value);
                DeferredObjectLoader.add(objectSetter);
            } else {
                this.field.set(obj, value);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.field.getAnnotations();
        }

        public String toString() {
            return String.format("Value(Field): %s (%s)", this.field.getName(), this.field.getType().getSimpleName());
        }
    }
}

