/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.converters;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.LoadedObjectResolver;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.utils.MapperUtils;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class MappingConverter {
    private final IBaseAeroMapper mapper;
    private final IAerospikeClient aerospikeClient;

    public MappingConverter(IBaseAeroMapper mapper, IAerospikeClient aerospikeClient) {
        this.mapper = mapper;
        this.aerospikeClient = aerospikeClient;
    }

    public Object translateToAerospike(Object obj) {
        if (obj == null) {
            return null;
        }
        TypeMapper thisMapper = TypeUtils.getMapper(obj.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
        return thisMapper == null ? obj : thisMapper.toAerospikeFormat(obj);
    }

    public <T> T translateFromAerospike(@NotNull Object obj, @NotNull Class<T> expectedClazz) {
        TypeMapper thisMapper = TypeUtils.getMapper(expectedClazz, TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
        Object result = thisMapper == null ? obj : thisMapper.fromAerospikeFormat(obj);
        this.resolveDependencies(ClassCache.getInstance().loadClass(expectedClazz, this.mapper));
        return (T)result;
    }

    public <T> T convertToObject(Class<T> clazz, Record record) {
        try {
            return this.convertToObject(clazz, record, null);
        }
        catch (ReflectiveOperationException e) {
            throw new AerospikeException((Throwable)e);
        }
    }

    public <T> T convertToObject(Class<T> clazz, Record record, ClassCacheEntry<T> entry) throws ReflectiveOperationException {
        return this.convertToObject(clazz, record, entry, true);
    }

    public <T> T convertToObject(Class<T> clazz, Record record, ClassCacheEntry<T> entry, boolean resolveDependencies) throws ReflectiveOperationException {
        if (entry == null) {
            entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
        }
        T result = entry.constructAndHydrate(record);
        if (resolveDependencies) {
            this.resolveDependencies(entry);
        }
        return result;
    }

    public <T> T convertToObject(Class<T> clazz, List<Object> record) {
        return this.convertToObject(clazz, record, true);
    }

    public <T> T convertToObject(Class<T> clazz, List<Object> record, boolean resolveDependencies) {
        try {
            ClassCacheEntry<T> entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
            T result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            entry.hydrateFromList(record, result);
            if (resolveDependencies) {
                this.resolveDependencies(entry);
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new AerospikeException((Throwable)e);
        }
    }

    public <T> T convertToObject(Class<T> clazz, Map<String, Object> record) {
        ClassCacheEntry<T> entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
        return entry.constructAndHydrate(record);
    }

    public <T> List<Object> convertToList(@NotNull T instance) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(instance.getClass(), this.mapper);
        return entry.getList(instance, false, false);
    }

    public <T> Map<String, Object> convertToMap(@NotNull T instance) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(instance.getClass(), this.mapper);
        return entry.getMap(instance, false);
    }

    private Key createKey(ClassCacheEntry<?> entry, DeferredObjectLoader.DeferredObject deferredObject) {
        if (deferredObject.isDigest()) {
            return new Key(entry.getNamespace(), (byte[])deferredObject.getKey(), entry.getSetName(), null);
        }
        return new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.translateKeyToAerospikeKey(deferredObject.getKey())));
    }

    public void resolveDependencies(ClassCacheEntry<?> parentEntity) {
        List<DeferredObjectLoader.DeferredObjectSetter> deferredObjects = DeferredObjectLoader.getAndClear();
        if (deferredObjects.size() == 0) {
            return;
        }
        BatchPolicy batchPolicy = parentEntity == null ? this.aerospikeClient.getBatchPolicyDefault() : parentEntity.getBatchPolicy();
        BatchPolicy batchPolicyClone = new BatchPolicy(batchPolicy);
        while (!deferredObjects.isEmpty()) {
            ArrayList<Key> keyList = new ArrayList<Key>();
            ArrayList classCacheEntryList = new ArrayList();
            Iterator<DeferredObjectLoader.DeferredObjectSetter> iterator = deferredObjects.iterator();
            while (iterator.hasNext()) {
                DeferredObjectLoader.DeferredObjectSetter thisObjectSetter = iterator.next();
                DeferredObjectLoader.DeferredObject deferredObject = thisObjectSetter.getObject();
                Class<?> clazz = deferredObject.getType();
                ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this.mapper);
                Key aKey = this.createKey(entry, deferredObject);
                Object result = LoadedObjectResolver.get(aKey);
                if (result != null) {
                    thisObjectSetter.getSetter().setValue(result);
                    iterator.remove();
                    continue;
                }
                keyList.add(aKey);
                classCacheEntryList.add(entry);
            }
            int size = keyList.size();
            if (size > 0) {
                Key[] keys = keyList.toArray(new Key[0]);
                batchPolicyClone.maxConcurrentThreads = keys.length <= 2 ? 1 : batchPolicy.maxConcurrentThreads;
                Record[] records = this.aerospikeClient.get(batchPolicyClone, keys);
                for (int i = 0; i < size; ++i) {
                    DeferredObjectLoader.DeferredObjectSetter thisObjectSetter = deferredObjects.get(i);
                    try {
                        ThreadLocalKeySaver.save(keys[i]);
                        Object result = records[i] == null ? null : this.convertToObject(thisObjectSetter.getObject().getType(), records[i], (ClassCacheEntry)classCacheEntryList.get(i), false);
                        thisObjectSetter.getSetter().setValue(result);
                        continue;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new AerospikeException((Throwable)e);
                    }
                    finally {
                        ThreadLocalKeySaver.clear();
                    }
                }
            }
            deferredObjects = DeferredObjectLoader.getAndClear();
        }
    }
}

