/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArrayMapper
extends TypeMapper {
    private final Class<?> instanceClass;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper instanceClassMapper;
    private final Boolean allowBatch;

    public ArrayMapper(Class<?> instanceClass, TypeMapper instanceClassMapper, boolean allowBatch) {
        this.instanceClass = instanceClass;
        this.supportedWithoutTranslation = TypeUtils.isByteType(instanceClass);
        this.instanceClassMapper = instanceClassMapper;
        this.allowBatch = allowBatch;
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        int length = Array.getLength(value);
        if (this.supportedWithoutTranslation) {
            return value;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            results.add(this.instanceClassMapper.toAerospikeFormat(Array.get(value, i)));
        }
        return results;
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        if (this.supportedWithoutTranslation) {
            return value;
        }
        Object result = Array.newInstance(this.instanceClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            Object item = this.instanceClassMapper.fromAerospikeFormat(obj);
            if (!this.allowBatch.booleanValue() || !(item instanceof DeferredObjectLoader.DeferredObject)) {
                Array.set(result, i, item);
                continue;
            }
            int thisIndex = i;
            DeferredObjectLoader.DeferredSetter setter = object -> Array.set(result, thisIndex, object);
            DeferredObjectLoader.add(new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)item));
        }
        return result;
    }
}

