/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.util.Map;
import java.util.TreeMap;

public class MapMapper
extends TypeMapper {
    private final Class<?> referencedClass;
    private final Class<?> itemClass;
    private final Class<?> keyClass;
    private final IBaseAeroMapper mapper;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper itemMapper;
    private final TypeMapper keyMapper;

    public MapMapper(Class<?> clazz, Class<?> keyClass, Class<?> itemClass, TypeMapper keyMapper, TypeMapper itemMapper, IBaseAeroMapper mapper) {
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.keyMapper = keyMapper;
        this.keyClass = keyClass;
        this.itemMapper = itemMapper;
        this.itemClass = itemClass;
        this.supportedWithoutTranslation = TypeUtils.isAerospikeNativeType(itemClass) && TypeUtils.isAerospikeNativeType(keyClass);
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map.size() == 0 || this.supportedWithoutTranslation) {
            return value;
        }
        TreeMap<Object, Object> results = new TreeMap<Object, Object>();
        for (Object key : map.keySet()) {
            Object item = map.get(key);
            TypeMapper keyMap = this.keyMapper != null ? this.keyMapper : TypeUtils.getMapper(key.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper itemMap = this.itemMapper != null ? this.itemMapper : TypeUtils.getMapper(item.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            results.put(keyMap.toAerospikeFormat(key), itemMap.toAerospikeFormat(item));
        }
        return results;
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map.size() == 0 || this.supportedWithoutTranslation) {
            return value;
        }
        TreeMap<Object, Object> results = new TreeMap<Object, Object>();
        for (Object key : map.keySet()) {
            Object javaItem;
            Object item = map.get(key);
            TypeMapper keyMap = this.keyMapper != null ? this.keyMapper : TypeUtils.getMapper(key.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            TypeMapper itemMap = this.itemMapper != null ? this.itemMapper : TypeUtils.getMapper(item.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
            Object javaKey = keyMap == null ? null : keyMap.fromAerospikeFormat(key);
            Object object2 = javaItem = itemMap == null ? null : itemMap.fromAerospikeFormat(item);
            if (javaKey instanceof DeferredObjectLoader.DeferredObject || javaItem instanceof DeferredObjectLoader.DeferredObject) {
                DeferredObjectLoader.DeferredSetter setter = object -> results.put(javaKey, object);
                DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)javaItem);
                DeferredObjectLoader.add(objectSetter);
                continue;
            }
            results.put(javaKey, javaItem);
        }
        return results;
    }
}

