/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.client.AerospikeException;
import com.aerospike.mapper.annotations.AerospikeEmbed;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.mappers.ObjectMapper;
import java.util.List;
import java.util.Map;

public class ObjectEmbedMapper
extends ObjectMapper {
    private final Class<?> referencedClass;
    private final IBaseAeroMapper mapper;
    private final AerospikeEmbed.EmbedType type;
    private final boolean skipKey;

    public ObjectEmbedMapper(Class<?> clazz, AerospikeEmbed.EmbedType type, IBaseAeroMapper mapper, boolean skipKey) {
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.type = type;
        this.skipKey = skipKey;
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isSimple(value)) {
            return value;
        }
        boolean needsType = !this.referencedClass.equals(value.getClass());
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(value.getClass(), this.mapper, false);
        switch (this.type) {
            case LIST: {
                return entry.getList(value, this.skipKey, needsType);
            }
            case MAP: 
            case DEFAULT: {
                return entry.getMap(value, needsType);
            }
        }
        throw new AerospikeException("Unspecified EmbedType");
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isSimple(value)) {
            return value;
        }
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(this.referencedClass, this.mapper);
        try {
            switch (this.type) {
                case LIST: {
                    List listValue = (List)value;
                    return entry.constructAndHydrate(listValue, this.skipKey);
                }
                case MAP: 
                case DEFAULT: {
                    return entry.constructAndHydrate((Map)value);
                }
            }
            throw new AerospikeException("Unspecified EmbedType");
        }
        catch (Exception e) {
            throw new AerospikeException((Throwable)e);
        }
    }

    private boolean isSimple(Object value) {
        Class<?> clazz = value.getClass();
        return clazz.isPrimitive() || clazz.equals(Object.class) || clazz.equals(String.class) || clazz.equals(Character.class) || Number.class.isAssignableFrom(clazz);
    }
}

