/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.util.Crypto;
import com.aerospike.mapper.annotations.AerospikeReference;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.mappers.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectReferenceMapper
extends ObjectMapper {
    private final ClassCacheEntry<?> referencedClass;
    private final IBaseAeroMapper mapper;
    private final boolean lazy;
    private final boolean allowBatch;
    private final AerospikeReference.ReferenceType type;

    public ObjectReferenceMapper(ClassCacheEntry<?> entry, boolean lazy, boolean allowBatch, AerospikeReference.ReferenceType type, IBaseAeroMapper mapper) {
        this.referencedClass = entry;
        this.mapper = mapper;
        this.lazy = lazy;
        this.type = type;
        this.allowBatch = allowBatch;
        if (AerospikeReference.ReferenceType.DIGEST.equals((Object)this.type) && this.lazy) {
            throw new AerospikeException("An object reference to a " + entry.getClass().getSimpleName() + " cannot be both lazy and map to a digest");
        }
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        return this.toAerospikeFormat(value, false, false);
    }

    @Override
    public Object toAerospikeFormat(Object value, boolean isUnknownType, boolean isSubclassOfKnownType) {
        ClassCacheEntry<?> classToUse;
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(this.referencedClass.getUnderlyingClass())) {
            classToUse = this.referencedClass;
        } else {
            classToUse = ClassCache.getInstance().loadClass(value.getClass(), this.mapper);
            isSubclassOfKnownType = true;
        }
        Object key = classToUse.getKey(value);
        if (AerospikeReference.ReferenceType.DIGEST.equals((Object)this.type)) {
            key = Crypto.computeDigest((String)classToUse.getSetName(), (Value)Value.get((Object)key));
        }
        if (isSubclassOfKnownType || isUnknownType) {
            ArrayList<Object> keyParts = new ArrayList<Object>();
            keyParts.add(key);
            if (isUnknownType) {
                keyParts.add("@T:" + classToUse.getShortenedClassName());
            } else {
                keyParts.add(classToUse.getShortenedClassName());
            }
            return keyParts;
        }
        return key;
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        Object key;
        if (value == null) {
            return null;
        }
        ClassCacheEntry<?> classToUse = this.referencedClass;
        if (value instanceof List) {
            List list = (List)value;
            key = list.get(0);
            String typeName = (String)list.get(1);
            if (typeName.startsWith("@T:")) {
                typeName = typeName.substring("@T:".length());
            }
            classToUse = ClassCache.getInstance().getCacheEntryFromStoredName(typeName);
        } else {
            key = value;
        }
        if (this.lazy) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object instance = classToUse.constructAndHydrate(map);
            classToUse.setKey(instance, key);
            return instance;
        }
        if (this.allowBatch) {
            return new DeferredObjectLoader.DeferredObject(key, classToUse.getUnderlyingClass(), AerospikeReference.ReferenceType.DIGEST.equals((Object)this.type));
        }
        if (AerospikeReference.ReferenceType.DIGEST.equals((Object)this.type)) {
            return this.mapper.asMapper().readFromDigest(classToUse.getUnderlyingClass(), (byte[])key, false);
        }
        return this.mapper.asMapper().read(classToUse.getUnderlyingClass(), key, false);
    }
}

