/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.IAeroMapper;
import com.aerospike.mapper.tools.mappers.ListMapper;
import com.aerospike.mapper.tools.virtuallist.Interactor;
import com.aerospike.mapper.tools.virtuallist.ResultsUnpacker;
import com.aerospike.mapper.tools.virtuallist.ReturnType;
import com.aerospike.mapper.tools.virtuallist.VirtualListInteractors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;

public class MultiOperation<E> {
    final List<Interactor> interactions = new ArrayList<Interactor>();
    int indexToReturn = -1;
    final WritePolicy writePolicy;
    final String binName;
    final ListMapper listMapper;
    Key key;
    final VirtualListInteractors virtualListInteractors;
    final IAeroMapper mapper;

    MultiOperation(@NotNull WritePolicy writePolicy, String binName, ListMapper listMapper, Key key, VirtualListInteractors virtualListInteractors, IAeroMapper mapper) {
        this.writePolicy = writePolicy;
        this.binName = binName;
        this.listMapper = listMapper;
        this.key = key;
        this.virtualListInteractors = virtualListInteractors;
        this.mapper = mapper;
    }

    public MultiOperation<E> append(E item) {
        Object aerospikeItem = this.listMapper.toAerospikeInstanceFormat(item);
        this.interactions.add(new Interactor(this.virtualListInteractors.getAppendOperation(aerospikeItem), new ResultsUnpacker[0]));
        return this;
    }

    public MultiOperation<E> removeByKey(Object key) {
        this.interactions.add(this.virtualListInteractors.getRemoveKeyInteractor(key));
        return this;
    }

    public MultiOperation<E> removeByKeyRange(Object startKey, Object endKey) {
        this.interactions.add(this.virtualListInteractors.getRemoveKeyRangeInteractor(startKey, endKey));
        return this;
    }

    public MultiOperation<E> removeByValue(Object value) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueInteractor(value));
        return this;
    }

    public MultiOperation<E> removeByValueList(List<Object> values) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueListInteractor(values));
        return this;
    }

    public MultiOperation<E> removeByValueRange(Object startValue, Object endValue) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRangeInteractor(startValue, endValue));
        return this;
    }

    public MultiOperation<E> removeByValueRelativeRankRange(Object value, int rank) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank));
        return this;
    }

    public MultiOperation<E> removeByValueRelativeRankRange(Object value, int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank, count));
        return this;
    }

    public MultiOperation<E> removeByIndex(int index) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexInteractor(index));
        return this;
    }

    public MultiOperation<E> removeByIndexRange(int index) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexRangeInteractor(index));
        return this;
    }

    public MultiOperation<E> removeByIndexRange(int index, int count) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexRangeInteractor(index, count));
        return this;
    }

    public MultiOperation<E> removeByRank(int rank) {
        this.interactions.add(this.virtualListInteractors.getRemoveByRankInteractor(rank));
        return this;
    }

    public MultiOperation<E> removeByRankRange(int rank) {
        this.interactions.add(this.virtualListInteractors.getRemoveByRankRangeInteractor(rank));
        return this;
    }

    public MultiOperation<E> removeByRankRange(int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getRemoveByRankRangeInteractor(rank, count));
        return this;
    }

    public MultiOperation<E> getByValue(Object value) {
        this.interactions.add(this.virtualListInteractors.getGetByValueInteractor(value));
        return this;
    }

    public MultiOperation<E> getByValueRange(Object startValue, Object endValue) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRangeInteractor(startValue, endValue));
        return this;
    }

    public MultiOperation<E> getByValueList(List<Object> values) {
        this.interactions.add(this.virtualListInteractors.getGetByValueListInteractor(values));
        return this;
    }

    public MultiOperation<E> getByValueRelativeRankRange(Object value, int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank));
        return this;
    }

    public MultiOperation<E> getByValueRelativeRankRange(Object value, int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank, count));
        return this;
    }

    public MultiOperation<E> getByIndexRange(int index) {
        this.interactions.add(this.virtualListInteractors.getGetByIndexRangeInteractor(index));
        return this;
    }

    public MultiOperation<E> getByIndexRange(int index, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByIndexRangeInteractor(index, count));
        return this;
    }

    public MultiOperation<E> getByRank(int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByRankInteractor(rank));
        return this;
    }

    public MultiOperation<E> getByRankRange(int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByRankRangeInteractor(rank));
        return this;
    }

    public MultiOperation<E> getByRankRange(int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByRankRangeInteractor(rank, count));
        return this;
    }

    public MultiOperation<E> getByKey(Object key) {
        this.interactions.add(this.virtualListInteractors.getGetByKeyInteractor(key));
        return this;
    }

    public MultiOperation<E> getByKeyRange(Object startKey, Object endKey) {
        this.interactions.add(this.virtualListInteractors.getGetByKeyRangeInteractor(startKey, endKey));
        return this;
    }

    public MultiOperation<E> get(int index) {
        this.interactions.add(this.virtualListInteractors.getByIndexInteractor(index));
        return this;
    }

    public MultiOperation<E> size() {
        this.interactions.add(this.virtualListInteractors.getSizeInteractor());
        return this;
    }

    public MultiOperation<E> clear() {
        this.interactions.add(this.virtualListInteractors.getClearInteractor());
        return this;
    }

    public MultiOperation<E> asResult() {
        return this.asResultOfType(ReturnType.DEFAULT);
    }

    public MultiOperation<E> asResultOfType(ReturnType type) {
        if (this.interactions.isEmpty()) {
            throw new AerospikeException("asResult() cannot mark an item as the function result if there are no items to process");
        }
        if (this.indexToReturn >= 0) {
            throw new AerospikeException("asResult() can only be called once in a multi operation");
        }
        this.indexToReturn = this.interactions.size() - 1;
        this.interactions.get(this.indexToReturn).setNeedsResultOfType(type);
        return this;
    }

    public Object end() {
        return this.end(null);
    }

    public <T> T end(Class<T> resultType) {
        Object result;
        if (this.interactions.isEmpty()) {
            return null;
        }
        this.writePolicy.respondAllOps = true;
        Operation[] operations = new Operation[this.interactions.size()];
        int listSize = this.interactions.size();
        if (this.indexToReturn < 0) {
            for (int i = listSize - 1; i >= 0; --i) {
                if (this.interactions.get(i).isWriteOperation()) continue;
                this.indexToReturn = i;
                this.interactions.get(this.indexToReturn).setNeedsResultOfType(ReturnType.DEFAULT);
                break;
            }
        }
        int count = 0;
        for (Interactor thisInteractor : this.interactions) {
            operations[count++] = thisInteractor.getOperation();
        }
        Record record = this.mapper.asMapper().getClient().operate(this.writePolicy, this.key, operations);
        if (count == 1) {
            Object resultObj = record.getValue(this.binName);
            result = this.interactions.get(0).getResult(resultObj);
        } else {
            List resultList = record.getList(this.binName);
            if (this.indexToReturn < 0) {
                this.indexToReturn = listSize - 1;
                for (int i = listSize - 1; i >= 0; --i) {
                    if (this.interactions.get(i).isWriteOperation()) continue;
                    this.indexToReturn = i;
                    break;
                }
            }
            result = this.interactions.get(this.indexToReturn).getResult(resultList.get(this.indexToReturn));
        }
        if (result != null) {
            Object object = result;
            if (result instanceof Collection) {
                Collection collection = (Collection)result;
                Object object2 = object = collection.isEmpty() ? null : (Object)collection.iterator().next();
            }
            assert (object != null);
            this.mapper.getMappingConverter().resolveDependencies(ClassCache.getInstance().loadClass(object.getClass(), this.mapper));
        }
        return (T)result;
    }
}

