/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.aerospike;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.policy.ClientPolicy;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.aerospike.AerospikeProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ValidateHostsProperty;
import org.springframework.boot.autoconfigure.util.AerospikeConfigurationUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration
@ConditionalOnClass(value={IAerospikeClient.class})
@Conditional(value={ValidateHostsProperty.class})
@EnableConfigurationProperties(value={AerospikeProperties.class})
public class AerospikeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ClientPolicy aerospikeClientPolicy(AerospikeProperties properties) {
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.eventLoops = new NioEventLoops();
        return AerospikeConfigurationUtils.getClientPolicyConfig(clientPolicy, properties);
    }
}

