/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.util;

import com.aerospike.client.Host;
import com.aerospike.client.policy.BatchDeletePolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.BatchUDFPolicy;
import com.aerospike.client.policy.BatchWritePolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.aerospike.AerospikeProperties;
import org.springframework.boot.autoconfigure.data.aerospike.AerospikeDataProperties;
import org.springframework.data.aerospike.config.AerospikeDataSettings;

public class AerospikeConfigurationUtils {
    public static List<Host> getClientHosts(AerospikeProperties properties) {
        if (properties.getHosts() != null) {
            Host[] hosts = Host.parseHosts((String)properties.getHosts(), (int)properties.getDefaultPort());
            return Arrays.stream(hosts).toList();
        }
        return null;
    }

    public static ClientPolicy getClientPolicyConfig(ClientPolicy clientPolicy, AerospikeProperties properties) {
        AerospikeConfigurationUtils.whenPresent(properties.getUser(), p -> {
            clientPolicy.user = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getPassword(), p -> {
            clientPolicy.password = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getClusterName(), p -> {
            clientPolicy.clusterName = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getAuthMode(), p -> {
            clientPolicy.authMode = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getConnectTimeout(), p -> {
            clientPolicy.timeout = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(properties.getLoginTimeout(), p -> {
            clientPolicy.loginTimeout = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(properties.getMinConnsPerNode(), p -> {
            clientPolicy.minConnsPerNode = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getMaxConnsPerNode(), p -> {
            clientPolicy.maxConnsPerNode = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getConnPoolsPerNode(), p -> {
            clientPolicy.connPoolsPerNode = p;
        });
        AerospikeConfigurationUtils.whenPresent(properties.getMaxSocketIdle(), p -> {
            clientPolicy.maxSocketIdle = (int)p.getSeconds();
        });
        AerospikeConfigurationUtils.whenPresent(properties.getTendInterval(), p -> {
            clientPolicy.tendInterval = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(properties.getFailIfNotConnected(), p -> {
            clientPolicy.failIfNotConnected = p;
        });
        clientPolicy.readPolicyDefault = AerospikeConfigurationUtils.setupReadPolicy(properties);
        clientPolicy.writePolicyDefault = AerospikeConfigurationUtils.setupWritePolicy(properties);
        clientPolicy.batchPolicyDefault = AerospikeConfigurationUtils.setupBatchPolicy(properties);
        clientPolicy.queryPolicyDefault = AerospikeConfigurationUtils.setupQueryPolicy(properties);
        clientPolicy.batchWritePolicyDefault = AerospikeConfigurationUtils.setupBatchWritePolicy(properties);
        clientPolicy.batchDeletePolicyDefault = AerospikeConfigurationUtils.setupBatchDeletePolicy(properties);
        clientPolicy.batchUDFPolicyDefault = AerospikeConfigurationUtils.setupBatchUDFPolicy(properties);
        return clientPolicy;
    }

    private static WritePolicy setupWritePolicy(AerospikeProperties properties) {
        AerospikeProperties.WritePolicyDefault writePolicyDefault = properties.getWrite();
        WritePolicy policy = new WritePolicy();
        AerospikeConfigurationUtils.setGeneralPolicyProperties((Policy)policy, writePolicyDefault);
        AerospikeConfigurationUtils.whenPresent(writePolicyDefault.durableDelete, p -> {
            policy.durableDelete = p;
        });
        return policy;
    }

    private static Policy setupReadPolicy(AerospikeProperties properties) {
        AerospikeProperties.ReadPolicyDefault readPolicyDefault = properties.getRead();
        Policy policy = new Policy();
        AerospikeConfigurationUtils.setGeneralPolicyProperties(policy, readPolicyDefault);
        return policy;
    }

    private static BatchPolicy setupBatchPolicy(AerospikeProperties properties) {
        AerospikeProperties.BatchPolicyDefault batchPolicyDefault = properties.getBatch();
        BatchPolicy policy = new BatchPolicy();
        AerospikeConfigurationUtils.setGeneralPolicyProperties((Policy)policy, batchPolicyDefault);
        AerospikeConfigurationUtils.whenPresent(batchPolicyDefault.maxConcurrentThreads, p -> {
            policy.maxConcurrentThreads = p;
        });
        AerospikeConfigurationUtils.whenPresent(batchPolicyDefault.allowInline, p -> {
            policy.allowInline = p;
        });
        AerospikeConfigurationUtils.whenPresent(batchPolicyDefault.sendSetName, p -> {
            policy.sendSetName = p;
        });
        return policy;
    }

    private static BatchWritePolicy setupBatchWritePolicy(AerospikeProperties properties) {
        AerospikeProperties.BatchWritePolicyDefault batchWritePolicyDefault = properties.getBatchWrite();
        BatchWritePolicy policy = new BatchWritePolicy();
        AerospikeConfigurationUtils.whenPresent(batchWritePolicyDefault.durableDelete, p -> {
            policy.durableDelete = p;
        });
        return policy;
    }

    private static BatchDeletePolicy setupBatchDeletePolicy(AerospikeProperties properties) {
        AerospikeProperties.BatchDeletePolicyDefault batchDeletePolicyDefault = properties.getBatchDelete();
        BatchDeletePolicy policy = new BatchDeletePolicy();
        AerospikeConfigurationUtils.whenPresent(batchDeletePolicyDefault.durableDelete, p -> {
            policy.durableDelete = p;
        });
        return policy;
    }

    private static BatchUDFPolicy setupBatchUDFPolicy(AerospikeProperties properties) {
        AerospikeProperties.BatchUDFPolicyDefault batchUDFPolicyDefault = properties.getBatchUdf();
        BatchUDFPolicy policy = new BatchUDFPolicy();
        AerospikeConfigurationUtils.whenPresent(batchUDFPolicyDefault.durableDelete, p -> {
            policy.durableDelete = p;
        });
        return policy;
    }

    private static QueryPolicy setupQueryPolicy(AerospikeProperties properties) {
        AerospikeProperties.QueryPolicyDefault queryPolicyDefault = properties.getQuery();
        QueryPolicy policy = new QueryPolicy();
        AerospikeConfigurationUtils.setGeneralPolicyProperties((Policy)policy, queryPolicyDefault);
        AerospikeConfigurationUtils.whenPresent(queryPolicyDefault.maxRecords, p -> {
            policy.maxRecords = p;
        });
        AerospikeConfigurationUtils.whenPresent(queryPolicyDefault.failOnClusterChange, p -> {
            policy.failOnClusterChange = p;
        });
        AerospikeConfigurationUtils.whenPresent(queryPolicyDefault.includeBinData, p -> {
            policy.includeBinData = p;
        });
        AerospikeConfigurationUtils.whenPresent(queryPolicyDefault.maxConcurrentNodes, p -> {
            policy.maxConcurrentNodes = p;
        });
        AerospikeConfigurationUtils.whenPresent(queryPolicyDefault.recordQueueSize, p -> {
            policy.recordQueueSize = p;
        });
        return policy;
    }

    private static void setGeneralPolicyProperties(Policy policy, AerospikeProperties.PolicyDefault policyDefault) {
        AerospikeConfigurationUtils.whenPresent(policyDefault.socketTimeout, p -> {
            policy.socketTimeout = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(policyDefault.totalTimeout, p -> {
            policy.totalTimeout = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(policyDefault.timeoutDelay, p -> {
            policy.timeoutDelay = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(policyDefault.maxRetries, p -> {
            policy.maxRetries = p;
        });
        AerospikeConfigurationUtils.whenPresent(policyDefault.sleepBetweenRetries, p -> {
            policy.sleepBetweenRetries = (int)p.toMillis();
        });
        AerospikeConfigurationUtils.whenPresent(policyDefault.sendKey, p -> {
            policy.sendKey = p;
        });
    }

    private static <T> void whenPresent(T param, Consumer<T> consumer) {
        if (param != null) {
            consumer.accept(param);
        }
    }

    public static String getNamespace(AerospikeDataProperties dataProperties) {
        if (dataProperties.getNamespace() != null) {
            return dataProperties.getNamespace();
        }
        return null;
    }

    public static void getDataSettings(AerospikeDataProperties dataProperties, AerospikeDataSettings aerospikeDataSettings) {
        AerospikeConfigurationUtils.whenPresent(dataProperties.isScansEnabled(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setScansEnabled(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.isCreateIndexesOnStartup(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setCreateIndexesOnStartup(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.getIndexCacheRefreshSeconds(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setIndexCacheRefreshSeconds(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.getServerVersionRefreshSeconds(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setServerVersionRefreshSeconds(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.getQueryMaxRecords(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setQueryMaxRecords(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.getBatchWriteSize(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setBatchWriteSize(arg_0));
        AerospikeConfigurationUtils.whenPresent(dataProperties.isKeepOriginalKeyTypes(), arg_0 -> ((AerospikeDataSettings)aerospikeDataSettings).setKeepOriginalKeyTypes(arg_0));
    }
}

