/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.client.reactive.autoconfigure;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.reactor.AerospikeReactorClient;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.IsClientOnly;
import org.springframework.boot.client.autoconfigure.AerospikeClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import reactor.core.publisher.Flux;

@AutoConfiguration
@Conditional(value={IsClientOnly.class})
@ConditionalOnClass(value={IAerospikeClient.class, IAerospikeReactorClient.class, Flux.class})
@AutoConfigureAfter(value={AerospikeClientConfiguration.class})
public class AerospikeReactorClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeReactorClientConfiguration.class);

    @Bean(name={"aerospikeReactorClient"}, destroyMethod="")
    @ConditionalOnMissingBean
    public IAerospikeReactorClient aerospikeReactorClient(IAerospikeClient aerospikeClient) {
        log.info("Initializing Aerospike Reactor Java client");
        return new AerospikeReactorClient(aerospikeClient);
    }
}

