/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.client.autoconfigure;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.ClientPolicy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.aerospike.AerospikeAutoConfiguration;
import org.springframework.boot.autoconfigure.aerospike.AerospikeProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.IsClientOnly;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration
@Conditional(value={IsClientOnly.class})
@ConditionalOnClass(value={IAerospikeClient.class})
@AutoConfigureAfter(value={AerospikeAutoConfiguration.class})
public class AerospikeClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeClientConfiguration.class);

    @Bean(name={"aerospikeClient"}, destroyMethod="close")
    @ConditionalOnMissingBean(value={IAerospikeClient.class})
    public IAerospikeClient aerospikeClient(AerospikeProperties properties, ClientPolicy aerospikeClientPolicy) {
        log.info("Initializing Aerospike Java client");
        Host[] hosts = Host.parseHosts((String)properties.getHosts(), (int)properties.getDefaultPort());
        return new AerospikeClient(aerospikeClientPolicy, hosts);
    }
}

