/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.aerospike.reactive.data;

import com.aerospike.client.Host;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.policy.ClientPolicy;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.aerospike.AerospikeProperties;
import org.springframework.boot.autoconfigure.data.aerospike.AerospikeDataProperties;
import org.springframework.boot.autoconfigure.util.AerospikeConfigurationUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AbstractReactiveAerospikeDataConfiguration;
import org.springframework.data.aerospike.config.AerospikeDataSettings;

@Configuration
public class AerospikeReactiveDataConfiguration
extends AbstractReactiveAerospikeDataConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeReactiveDataConfiguration.class);
    @Autowired
    private AerospikeProperties properties;
    @Autowired
    private AerospikeDataProperties dataProperties;

    protected Collection<Host> getHosts() {
        return AerospikeConfigurationUtils.getClientHosts((AerospikeProperties)this.properties);
    }

    protected String nameSpace() {
        return AerospikeConfigurationUtils.getNamespace((AerospikeDataProperties)this.dataProperties);
    }

    public EventLoops eventLoops() {
        return new NioEventLoops();
    }

    protected ClientPolicy getClientPolicy() {
        return AerospikeConfigurationUtils.getClientPolicyConfig((ClientPolicy)super.getClientPolicy(), (AerospikeProperties)this.properties);
    }

    protected void configureDataSettings(AerospikeDataSettings aerospikeDataSettings) {
        AerospikeConfigurationUtils.getDataSettings((AerospikeDataProperties)this.dataProperties, (AerospikeDataSettings)aerospikeDataSettings);
    }
}

